/*
 * Decompiled with CFR 0.152.
 */
package perfdb.configure;

import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import perfdb.ConnectionManager;
import perfdb.util.dbinterface.DB;
import perfdb.util.dbinterface.ParseConfig;

public class Configure {
    private DB db = null;
    private static String Usage = "Usage: configure [{-h,--help}] [{-g,--configfile} filename] [{-p,--perfdbhome} path]";
    private static String Greeting = "\nWelcome to the configuration program for PerfDBF.\nThis program will prompt you for some information necessary to ensure\nthe desired behavior for the PerfDB tools.\n";
    private static String PDBHomePrompt = "Please enter the PerfDB home directory:";
    private String perfdb_home = "";
    private String jdbc_db_jarfile = "postgresql.jar";
    private String jdbc_db_driver = "org.postgresql.Driver";
    private String jdbc_db_type = "postgresql";
    private String db_hostname = "localhost";
    private String db_portnum = "5432";
    private String db_dbname = "perfdb";
    private String db_username = "";
    private String db_password = "";
    private String db_schemafile = "dbschema.txt";
    private String xml_parser = "xerces.jar";
    private ParseConfig parser;
    private boolean configFileFound = false;
    private String configFileName;

    public Configure(String perfDBHome) {
        this.perfdb_home = perfDBHome;
    }

    public void errorPrint(String msg) {
        System.err.println(msg);
    }

    public void initialize(String configFileNameIn) {
        block3: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(Greeting);
            try {
                this.configFileName = configFileNameIn;
                File configFile = new File(this.configFileName);
                if (configFile.exists()) {
                    System.out.println("Configuration file found...");
                    this.parseConfigFile();
                    this.configFileFound = true;
                    break block3;
                }
                System.out.println("Configuration file NOT found...");
                System.out.println("a new configuration file will be created.");
            }
            catch (IOException e) {
                System.out.println("I/O Error occurred.");
            }
        }
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        System.out.println("Parsing config file...");
        this.parser = new ParseConfig(this.configFileName);
        this.perfdb_home = this.parser.getPerfDBHome();
        this.jdbc_db_jarfile = this.parser.getJDBCJarFile();
        this.jdbc_db_driver = this.parser.getJDBCDriver();
        this.jdbc_db_type = this.parser.getDBType();
        this.db_hostname = this.parser.getDBHost();
        this.db_portnum = this.parser.getDBPort();
        this.db_dbname = this.parser.getDBName();
        this.db_username = this.parser.getDBUserName();
        this.db_password = this.parser.getDBPasswd();
        this.db_schemafile = this.parser.getDBSchema();
        this.xml_parser = this.parser.getXMLSAXParser();
    }

    public void promptForData() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nYou will now be prompted for new values, if desired.  The current or default\nvalues for each prompt are shown in parenthesis.\nTo accept the current/default value, just press Enter/Return.\n");
        try {
            System.out.print("Please enter the new PerfDB Home directory.\n(" + this.perfdb_home + "):");
            String tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.perfdb_home = tmpString;
            }
            if (this.configFileFound) {
                System.out.print("Please enter the JDBC jar file.\n(" + this.jdbc_db_jarfile + "):");
            } else {
                System.out.print("Please enter the JDBC jar file.\n(" + this.perfdb_home + "/jars/" + this.jdbc_db_jarfile + "):");
            }
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.jdbc_db_jarfile = tmpString;
            } else if (!this.configFileFound) {
                this.jdbc_db_jarfile = this.perfdb_home + "/jars/" + this.jdbc_db_jarfile;
            }
            System.out.print("Please enter the JDBC Driver name.\n(" + this.jdbc_db_driver + "):");
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.jdbc_db_driver = tmpString;
            }
            System.out.print("Please enter the database vendor.\n(" + this.jdbc_db_type + "):");
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.jdbc_db_type = tmpString;
            }
            System.out.print("Please enter the hostname for the database server.\n(" + this.db_hostname + "):");
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.db_hostname = tmpString;
            }
            System.out.print("Please enter the port number for the database JDBC connection.\n(" + this.db_portnum + "):");
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.db_portnum = tmpString;
            }
            System.out.print("Please enter the database name.\n(" + this.db_dbname + "):");
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.db_dbname = tmpString;
            }
            System.out.print("Please enter the database username.\n(" + this.db_username + "):");
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.db_username = tmpString;
            }
            if (this.configFileFound) {
                System.out.print("Please enter the PerfDBF schema file.\n(" + this.db_schemafile + "):");
            } else {
                System.out.print("Please enter the PerfDBF schema file.\n(" + this.perfdb_home + "/data/" + this.db_schemafile + "):");
            }
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.db_schemafile = tmpString;
            } else if (!this.configFileFound) {
                this.db_schemafile = this.perfdb_home + "/data/" + this.db_schemafile;
            }
            if (this.configFileFound) {
                System.out.print("Please enter the XML Parser jar file.\n(" + this.xml_parser + "):");
            } else {
                System.out.print("Please enter the XML Parser jar file.\n(" + this.perfdb_home + "/jars/" + this.xml_parser + "):");
            }
            tmpString = reader.readLine();
            if (tmpString.length() > 0) {
                this.xml_parser = tmpString;
            } else if (!this.configFileFound) {
                this.xml_parser = this.perfdb_home + "/jars/" + this.xml_parser;
            }
        }
        catch (IOException e) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void testDBConnection() {
    }

    public void testDBTransaction() {
    }

    public void writeConfigFile() {
        System.out.println("\nWriting configuration file: " + this.configFileName + "...");
        try {
            File configFile = new File(this.configFileName);
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            BufferedWriter configWriter = new BufferedWriter(new FileWriter(configFile));
            configWriter.write("# This is the configuration file for the PerfDBF tools & API\n");
            configWriter.write("# Items are listed as name:value, one per line.\n");
            configWriter.write("# Comment lines begin with a '#' symbol.\n");
            configWriter.write("# DO NOT EDIT THIS FILE!  It is modified by the configure utility.\n");
            configWriter.newLine();
            configWriter.write("# PerfDB home directory\n");
            configWriter.write("perfdb_home:" + this.perfdb_home + "\n");
            configWriter.newLine();
            configWriter.write("# Database JDBC jar file (with path to location)\n");
            configWriter.write("jdbc_db_jarfile:" + this.jdbc_db_jarfile + "\n");
            configWriter.newLine();
            configWriter.write("# Database JDBC driver name\n");
            configWriter.write("jdbc_db_driver:" + this.jdbc_db_driver + "\n");
            configWriter.newLine();
            configWriter.write("# Database type\n");
            configWriter.write("jdbc_db_type:" + this.jdbc_db_type + "\n");
            configWriter.newLine();
            configWriter.write("# Database host name\n");
            configWriter.write("db_hostname:" + this.db_hostname + "\n");
            configWriter.newLine();
            configWriter.write("# Database port number\n");
            configWriter.write("db_portnum:" + this.db_portnum + "\n");
            configWriter.newLine();
            configWriter.write("# Database name\n");
            configWriter.write("db_dbname:" + this.db_dbname + "\n");
            configWriter.newLine();
            configWriter.write("# Database username\n");
            configWriter.write("db_username:" + this.db_username + "\n");
            configWriter.newLine();
            configWriter.write("# Database Schema file - note: the path is absolulte\n");
            configWriter.write("db_schemafile:" + this.db_schemafile + "\n");
            configWriter.newLine();
            configWriter.write("# Database XML parser jar file - note: the path is absolulte\n");
            configWriter.write("xml_sax_parser:" + this.xml_parser + "\n");
            configWriter.newLine();
            configWriter.close();
        }
        catch (IOException e) {}
    }

    public void setPerfDBHome(String inString) {
        this.perfdb_home = inString;
    }

    public String getPerfDBHome() {
        return this.perfdb_home;
    }

    public void setJDBCJarfile(String inString) {
        this.jdbc_db_jarfile = inString;
    }

    public String getJDBCJarfile() {
        return this.jdbc_db_jarfile;
    }

    public void setJDBCDriver(String inString) {
        this.jdbc_db_driver = inString;
    }

    public String getJDBCDriver() {
        return this.jdbc_db_driver;
    }

    public void setJDBCType(String inString) {
        this.jdbc_db_type = inString;
    }

    public String getJDBCType() {
        return this.jdbc_db_type;
    }

    public void setDBHostname(String inString) {
        this.db_hostname = inString;
    }

    public String getDBHostname() {
        return this.db_hostname;
    }

    public void setDBPortNum(String inString) {
        this.db_portnum = inString;
    }

    public String getDBPortNum() {
        return this.db_portnum;
    }

    public void setDBName(String inString) {
        this.db_dbname = inString;
    }

    public String getDBName() {
        return this.db_dbname;
    }

    public void setDBUsername(String inString) {
        this.db_username = inString;
    }

    public String getDBUsername() {
        return this.db_username;
    }

    public void setDBPassword(String inString) {
        this.db_password = inString;
    }

    public String getDBPassword() {
        return this.db_password;
    }

    public void setDBSchemaFile(String inString) {
        this.db_schemafile = inString;
    }

    public String getDBSchemaFile() {
        return this.db_schemafile;
    }

    public void setXMLPaser(String inString) {
        this.xml_parser = inString;
    }

    public String getXMLPaser() {
        return this.xml_parser;
    }

    public void setConfigFileName(String inString) {
        this.configFileName = inString;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void createDB() {
        ConnectionManager connector = null;
        DB db = null;
        try {
            connector = new ConnectionManager(this.configFileName);
            connector.connectTest();
            db = connector.getDB();
        }
        catch (Exception e) {
            System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
            System.out.println("the database " + this.db_dbname + " has been created.");
            System.exit(0);
        }
        try {
            String query = new String("select * from application;");
            ResultSet resultSet = db.executeQuery(query);
            resultSet.close();
            connector.dbclose();
        }
        catch (Exception e) {
            System.out.println(this.configFileName);
            connector.genParentSchema(this.db_schemafile);
            connector.dbclose();
            System.out.println("Congratulations!  PerfDB is configured and the database has been built.");
            System.out.println("You may begin loading applications.");
        }
        System.out.println("Configuration complete.");
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option configfileOpt = parser.addStringOption('g', "configfile");
        CmdLineParser.Option homeOpt = parser.addStringOption('p', "perfdbhome");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String configFile = (String)parser.getOptionValue(configfileOpt);
        String perfDBHome = (String)parser.getOptionValue(homeOpt);
        Boolean help = (Boolean)parser.getOptionValue(helpOpt);
        if (help != null && help.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (configFile == null) {
            configFile = new String("");
        }
        if (perfDBHome == null) {
            perfDBHome = new String("");
        }
        Configure config = new Configure(perfDBHome);
        config.initialize(configFile);
        config.promptForData();
        config.testDBConnection();
        config.testDBTransaction();
        config.writeConfigFile();
        config.createDB();
    }
}

