/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: student_afternoon.c,v 1.6 2004/09/27 11:02:09 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Converted to module by Tomaz Solc <tomaz.solc@siol.net>
 *
 *  Ideas taken from a patch for Tablix 0.0.3 by 
 *  Jaume Obrador <obrador@espaiweb.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight whenever a class has lessons in the morning and the afternoon
 *  shifts in the same day.
 *
 * DEFINED OPTIONS:
 *
 *  <option name="morning-ends">7</option>
 *
 *  This option specifies the last period of the morning shift.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int endmorning;

int getperiod(char *type, char *cont, int tid)
{
	int p,c;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<0||p>periods) {
		strcpy(moderror, _("invalid period for morning end"));
		return(1);
	}


	endmorning=p;

	return 0;
}

parop options[] = { 
	{ type : "morning-ends", parfunc: getperiod },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	endmorning=-1;
	return 0;
}

int precalc_mod()
{
	if(endmorning<0) {
		strcpy(moderror, _("no period defined for morning end"));
		return(1);
	}
	return 0;
}


int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int c,b;
	int sum;
	int *pnt;
	int startp,endp;

	sum=0;

	pnt=cpnt;
        for(c=0;c<cmapnum*DAYS;c++) {
		startp=-1;
		endp=-1;
		for(b=0;b<PERIODS;b++) {
			if(*pnt!=-1) {
				if(startp==-1) startp=b;
				endp=b;
			}
			pnt++;
		}
		if(startp!=-1) {
			if(startp<=endmorning&&endp>endmorning) sum++;
		}
	}

	return(sum);
}
