/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: forcesametime.c,v 1.3 2004/01/09 16:46:18 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight whenever two classes that are required to be at
 *  at the same time have lessons scheduled at different times.
 *
 * DEFINED CLASS RESTRICTIONS:
 *
 *  <restriction type="same-time-as">year name</restriction>
 *
 *  This restriction specifies that current class should always have lessons
 *  at the same time as the class specified in the restriction. (two classes
 *  should have equal number of lessons for best effect).
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

struct sametime {
	int cid1;
	int cid2;
};

struct sametime *sametimeas;
int numsa;

int getconflict(char *type, char *cont, int cid)
{
	char name[256];
	int year,c;
	int confcid;

	c=sscanf(cont, "%d %s", &year, name);

	if(c<2) {
		strcpy(moderror, _("invalid format of same-time-as restriction"));
		return(1);
	}

	confcid=find_class(name, year);

	if (confcid==-1) {
		strcpy(moderror, _("invalid class in same-time-as restriction"));
		return(1);
	}

	sametimeas[numsa].cid1=cid;
	sametimeas[numsa].cid2=confcid;

	numsa++;

	return 0;
}

parop class_restrictions[] = { 
	{ type : "same-time-as", parfunc: getconflict },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	sametimeas=malloc(sizeof(*sametimeas)*cmapnum);

	if(sametimeas==NULL) {
		strcpy(moderror, _("Not enough memory"));
		return 1;
	}

	numsa=0;

	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int b,c;
	int sum;
	int *pnt1, *pnt2;

	sum=0;

        for(c=0;c<numsa;c++) {

		pnt1=&cpnt[sametimeas[c].cid1*TIMES];
		pnt2=&cpnt[sametimeas[c].cid2*TIMES];

                for(b=0;b<TIMES;b++) {
			if(*pnt1!=-1&&*pnt2==-1) sum++;
			pnt1++;
			pnt2++;
		}
	}

	return(sum);
}
