/* Main data structures for Quicklist 
 *
 *  Current owner:  Bob
 *
 */

#define MAX_FILES            12
#define MAX_FILE_NAME        30
#define MAX_RECORDS        5000
#define MAX_FIELDS           30
#define MAX_FIELD_NAME       30
#define MAX_SORTS            12
#define MAX_SORT_NESTING      6
#define MAX_FILTERS          12
#define MAX_FILTER_NESTING    6
#define MAX_FILTER_COMPARE   30
#define MAX_REPORTS          18
#define MAX_CLIPBOARD      5000

typedef enum _field_type { FIELD_TYPE_TEXT = 1,
                           FIELD_TYPE_NUMERIC,
                           FIELD_TYPE_DATE,
                           FIELD_TYPE_TIME
} field_type;

/* Structure to store each field's information in memory */
typedef struct _field_info {
  gint16 sheet_column; /* which sheet column it goes in */
  gint16  type; /* type of field 1: alpha 2: numeric 3: date 4: time */
  gint16 formatting; /* values from 0 to n */
  gint16 decimal_places;
  gint16 justification; /* Uses GTK-JUSTIFY_LEFT, RIGHT, CENTER */
  gint16 unused1, unused2;
  gint16 width;  /* display width in characters */
  char name [MAX_FIELD_NAME +2];
} field_info;

/* Structure to store one line of one sort. There can be up to 6 of
   these in one sort definition */
typedef struct _sort_line {
  gint16 field; /* Which field to sort on */
  gboolean  ascending; /* True: ascending, false: descending */
  gint16  column;
  gint unused; 
} sort_line;

/* Structure to store one complete sort specification in memory */
typedef struct _sort_info {
  char name  [MAX_FIELD_NAME + 2];
  gint16 line_ct; /* 0 is invalid */
  sort_line line [MAX_SORT_NESTING+1]; /* line [0] unused */
  gint16 unused1, unused2; 
} sort_info;

/* Structure to store one line of 1 filter */
typedef struct _filter_line {
  gboolean unused3; 
  gint16 field; /* -1 is "this field has been dropped */
  gint16 type; /* type of comparison, 0 .. n-1 */ 
  char compare [MAX_FILTER_COMPARE + 2];
  gint16 unused1, unused2;
} filter_line;

/* Structure to store one complete filter */
typedef struct _filter_info {
  char name [MAX_FIELD_NAME + 2];
  gint16 line_ct;
  gint16 unused2;
  gboolean by_and; /* True:  filter lines are linked by AND, False:  OR */
  filter_line line [MAX_FILTER_NESTING];  
    gboolean use_nocase;
} filter_info;

/* Structure to store one column's information in a report */
typedef struct _report_column {
  gint16 field; /* which field from the data base comes first */
  gint16 width; /* in characters */
  gint16 group; /* True or false, group summary on change this col */
  gint16 total; /* True or false, print totals this column */
  gint16 unused1, unused2;
} report_column;

/* Structure to store a whole report */
typedef struct _report_info {
  char name [MAX_FILE_NAME + 2];
  gint16 last_column;
  gint16 width;
  gint16 height;
  report_column column [MAX_FIELDS + 2]; /* column [0] is unused */
  gint16 sort; /* which sort rule, -1 means none */
  gint16 filter; /* which filter, -1 means none */
  char  header [80]; /* can be up to 80 characters */
  char footer [80]; /* likewise, I'm sure */
} report_info;
  
/* Structure to store a whole file in memory */
/* Use malloc to build these as needed */
typedef struct _whole_file {
  GtkWidget  *sheet;      /* sheet placed inside scroll_win */
  GtkWidget  *report_sheet;
  GtkWidget  *list_win; /* the main window it all goes in */
  GtkWidget *report_win;
  GtkWidget *text_box; /* just used from a lot of places */
  GtkWidget *entry1; /* entry boxes that might be open */
  GtkWidget *entry2;
  GtkWidget *entry3;
  GtkWidget *entry4;
  GtkWidget *dec_places_label;
  GtkWidget *clist_from;
  GtkWidget *clist_to;
  GtkWidget *text_button;
  GtkWidget *numeric_button;
  GtkWidget *date_button;
  GtkWidget *time_button;
  GtkWidget *left_button;
  GtkWidget *center_button;
  GtkWidget *right_button;
  GtkWidget *sm_numeric_menu;
  GtkWidget *sm_date_menu;
  GtkWidget *sm_time_menu;

  GtkItemFactory *list_menu;
  GtkItemFactory *report_menu;
  
  char *file_name; /* not path, just past last /  */
  char *file_path;  /* the complete file path */

  char display_mode; /* L(ist or R(eport */
  char report_mode; /* in report mode, E)dit or P(rint */

  /* keep track of last cell activated.  It's the only way to tell if
     it has been changed */
  gint activate_row;
  gint activate_col;
  char *activate_text;

  gboolean changed;
  gint32 last_row;
  gint16 last_field; /* IF 4 fields, value will be 3 */
  gint16 sort_ct;  /* IF 4 sorts, value will be 4 */
  gint16 filter_ct; /* if 4 filters, value will be 4 */
  gint16 report_ct;  /* if 4 reports, value will be 4 */
  gint16 width;
  gint16 height;
  gint16 x;
  gint16 y;
  filter_info *filter_ptr; /* zero is none */
  sort_info *sort_ptr; /* zero is none */
  report_info *report_ptr; /* zero is none */
  gint report_no;
  gchar* current_compare; /* for find and match */
  gboolean match_on;
  gboolean find_on;
  gchar sel_type; /* C(column) R(ow) B(lock. E(ntry) or \0 */
  GtkSheetRange sel_range;
  gint report_sel_col;
  gint report_sel_field; /* field that goes with sel_col */
  gint adjust_rows [8]; /* for report adjust window */ 

  field_info fields [MAX_FIELDS +1];  
  gint16 col_to_field [MAX_FIELDS + 1]; /* says col 0 is field 2, etc */
  sort_info sorts [MAX_SORTS + 1]; 
  filter_info filters [MAX_FILTERS + 1];  
  report_info reports [MAX_REPORTS + 1];  
} whole_file;
