/* dim_list.menu.c:  Functions to dim out the various list mode menus */
/*
 *  Copyright (C) 1999
 *  Author this code file:  Robert Lissner
 *
 *  Current owner:  Bob 
*/

#include "includes.h"
#include "globals.h"

void dim_all_menus () {
  if (front->display_mode == 'L') {
    dim_list_file_menu();
    dim_list_edit_menu();
    dim_list_sort_menu();
    dim_list_filter_menu();
    dim_list_report_menu();
    dim_list_column_menu();
  }
  else if (front->report_mode == 'E') /* don't do if print on screen */
    {
      dim_report_file_menu ();
      dim_report_column_menu ();
      dim_report_totals_menu ();
    } 
}

void dim_list_file_menu() {
  gboolean new = FALSE;
  gboolean open = FALSE;
  gboolean import = FALSE;

  if (file_ct < MAX_FILES) 
    new = open = import = TRUE;

  menus_set_sensitive ("<list>/File/New list...", new);
  menus_set_sensitive ("<list>/File/Open...", open);
  menus_set_sensitive ("<list>/File/Save" , front->changed);
  menus_set_sensitive ("<list>/File/Import...", import);

}

void dim_list_edit_menu() { 
  gboolean cut = FALSE;
  gboolean clear  = FALSE;
  gboolean copy  = FALSE;
  gboolean ditto = FALSE;
  gboolean paste = FALSE;
  gboolean fill  = FALSE;
  gboolean insert  = FALSE;
  
  if (front->sel_type) {
    clear = copy = cut = paste = TRUE;
    if (front->sel_range.rowi != front->sel_range.row0)
       fill = TRUE;
    if (front->sel_type == 'E')
      ditto = TRUE;
    if (front->sel_type != 'C')
      insert = TRUE;
  }
  menus_set_sensitive ("<list>/Edit/Cut", cut);
  menus_set_sensitive ("<list>/Edit/Copy", copy);
  menus_set_sensitive ("<list>/Edit/Copy down", ditto);
  menus_set_sensitive ("<list>/Edit/Clear", clear);
  menus_set_sensitive ("<list>/Edit/Fill down", fill);
  menus_set_sensitive ("<list>/Edit/Insert rows", insert);
  menus_set_sensitive ("<list>/Edit/Paste", paste_is_ok () );
  
} /* End of list_dim_edit */

void dim_list_sort_menu() {
  gboolean add    = FALSE;
  gboolean column = FALSE;
  gboolean apply  = FALSE;
  gboolean edit   = FALSE;
  gboolean delete = FALSE;
  
  if (front->sel_type == 'C' || front->sel_type == 'E')
     column = TRUE;
 
  if (front->sort_ct) 
     apply = edit = delete = TRUE;   

  if (front->sort_ct < MAX_SORTS)   
    add = TRUE;

  if (front->last_row <= 1) /* ie, need two real rows plus last row */
    apply = column = FALSE;

  menus_set_sensitive ("<list>/Sort/Add...", add); 
  menus_set_sensitive ("<list>/Sort/Apply...", apply); 
  menus_set_sensitive ("<list>/Sort/Edit...", edit); 
  menus_set_sensitive ("<list>/Sort/Delete...", delete); 
  menus_set_sensitive ("<list>/Sort/Column" , column); 
} /* end of dim_list_sort_menu */
 

void dim_list_filter_menu() {
  gboolean show = FALSE;
  gboolean apply = FALSE;
  gboolean edit = FALSE;
  gboolean delete = FALSE;
  gboolean add = FALSE;
   
    show = TRUE;

  if (front->filter_ct) 
    apply = edit = delete = TRUE;

  if (front->filter_ct < MAX_FILTERS)   
    add = TRUE;

  menus_set_sensitive ("<list>/Filter/Show all", show);  
  menus_set_sensitive ("<list>/Filter/Apply...", apply);  
  menus_set_sensitive ("<list>/Filter/Edit...", edit);  
  menus_set_sensitive ("<list>/Filter/Delete...", delete);  
  menus_set_sensitive ("<list>/Filter/Add...", add);  
} /* end of dim_list_filter_menu */



void dim_list_report_menu() {
  gboolean select = FALSE;
  gboolean add = FALSE;

  if (front->report_ct) 
    select = TRUE;

  if (front->report_ct < MAX_REPORTS)   
    add = TRUE;

  menus_set_sensitive ("<list>/Report/Select...", select);  
  menus_set_sensitive ("<list>/Report/Add...", add);  
} /* end of dim_list_report_menu */


void dim_list_column_menu() {
  gboolean add = FALSE;
  gboolean edit = FALSE;
  gboolean delete = FALSE;
  gboolean right = FALSE;
  gboolean left = FALSE;

 

  if (front->sel_range.col0 == front->sel_range.coli) {
    if (front->last_field < MAX_FIELDS - 1)   
      add = TRUE;
    if (front->sel_type == 'C') {
      edit = TRUE;   
      if (front->last_field) { /* ie two or more fields */
	delete = TRUE;
	if (front->sel_range.coli < front->last_field)
	  right= TRUE;
	if (front->sel_range.col0)
	  left = TRUE;
      }
    }
  }
  menus_set_sensitive ("<list>/Column/Add...", add);  
  menus_set_sensitive ("<list>/Column/Edit...", edit);  
  menus_set_sensitive ("<list>/Column/Delete", delete);  
  menus_set_sensitive ("<list>/Column/Move left", left);  
  menus_set_sensitive ("<list>/Column/Move right", right);  
} /* end of dim_list_column_menu */


void dim_report_file_menu() {
  gboolean new = FALSE;
  gboolean open = FALSE;
  gboolean import = FALSE;

  if (file_ct < MAX_FILES) 
    new = open = import = TRUE;

  menus_set_sensitive ("<report>/File/New...", new);
  menus_set_sensitive ("<report>/File/Open...", open);
  menus_set_sensitive ("<report>/File/Save", front->changed);
  menus_set_sensitive ("<report>/File/Import...", import);

}


void dim_report_column_menu() {
  gboolean add = FALSE;
  gboolean delete = FALSE;
  gboolean right = FALSE;
  gboolean left = FALSE;

  if (front->report_ptr->last_column < MAX_FIELDS - 1)   
    add = TRUE;

  if (front->report_sel_col >= 0)
    if (front->report_ptr->last_column) { /* ie two or more columns */
      delete = TRUE;
      if (front->report_sel_col < front->report_ptr->last_column)
	right= TRUE;
      if (front->report_sel_col)
	left = TRUE;
    }
  menus_set_sensitive ("<report>/Column/Add...", add);  
  menus_set_sensitive ("<report>/Column/Delete", delete);  
  menus_set_sensitive ("<report>/Column/Move right", right);  
  menus_set_sensitive ("<report>/Column/Move left", left);  
} /* end of dim_report_column_menu */


void dim_report_totals_menu() {
  gboolean group = FALSE;
  gboolean total = FALSE;
  if (front->report_sel_col >= 0) {
     group = TRUE;
     if (front->fields[front->report_sel_field].type == 2)
       total = TRUE;
  }
     
  menus_set_sensitive ("<report>/Totals/Group", group);  
  menus_set_sensitive ("<report>/Totals/Totals", total);  
} /* end of dim_report_totals_menu */


/* _________________________________
   |                                |
   |       paste_is_ok              |
   |________________________________| 
  Determine whether paste is allowed.  Depends on to and from conditions */
gboolean paste_is_ok () {
  if (!front->sel_type || !cb_sel_type)
    return FALSE;
  switch (cb_sel_type) {
  case 'R':
    if (front->sel_type == 'C')
      return FALSE;
    break;

  case 'C':
    if (front->sel_type != 'C')
      return FALSE;
    break;
  
  case 'B':
    if (front->sel_type != 'B' && front->sel_type != 'E')
      return FALSE;
    break;

  case 'E':
    if (front->sel_type != 'E')
      return FALSE;
    break;
  }
  return TRUE;
} /* end of paste_is_ok */
