/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;

/**
 * This class contains static functions to query information about the
 * Qt library Qt Jambi links against.
 */
public class QtInfo {

    static {
        QtJambi_LibraryInitializer.init();
    }

    /**
     * Returns The Qt version as a string on the form Major.Minor.Patch, e.g 4.1.2
     * @return The Qt version string
     */
    public static String versionString() {
        return String.format("%1$d.%2$d.%3$d", majorVersion(), minorVersion(), patchVersion());
    }


    /**
     * Returns the Qt version as a hexadecimal coded integer on the format
     * 0x00MMmmpp, where MM is major version, mm is minor version and pp is
     * patch version.
     *
     * @return the Qt version as a hexadecimal coded integer
     */
    public static int version() {
        return (majorVersion() << 16) | (minorVersion() << 8) | patchVersion();
    }


    /**
     * @return Qt's major version
     */
    public native static int majorVersion();


    /**
     * @return Qt's minor version
     */
    public native static int minorVersion();


    /**
     * @return Qt's patch version
     */
    public native static int patchVersion();
}
