/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DOCPARSER_H
#define DOCPARSER_H

#include <QtCore/QString>


class MetaJavaClass;
class MetaJavaFunction;
class MetaJavaEnum;
class MetaJavaEnumValue;
class QDomDocument;

class DocParser
{
public:
    DocParser(const QString &docFile);
    ~DocParser();

    QString documentation(const MetaJavaClass *meta_class) const;
    QString documentation(const MetaJavaEnum *meta_enum) const;
    QString documentation(const MetaJavaEnumValue *meta_enum) const;
    QString documentationForFunction(const QString &signature) const;
    QString documentationForSignal(const QString &signature) const;

private:
    QString documentationForFunction(const QString &signature, const QString &tag) const;
    void build();

    QString m_doc_file;
    QDomDocument *m_dom;
};

#endif // DOCPARSER_H
