/*
 * Token checksumming functions.
 *
 * Copyright 2005 Andrew Wood, distributed under the Artistic License.
 */

#include "config.h"
#include "md5.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*
 * Generate a checksum string of the given token and return a malloc()ed
 * pointer to it.
 */
unsigned char *spam_checksum(char *key, int len)
{
	struct MD5Context md5c;
	unsigned char digest[64];	 /* RATS: ignore (size OK) */
	char buf[16];			 /* RATS: ignore (size OK) */
	char resultstr[128];		 /* RATS: ignore (size OK) */
	char *ptr;
	int i;

	MD5Init(&md5c);
	MD5Update(&md5c, (unsigned char *) key, len);
	MD5Final(digest, &md5c);

	strcpy(resultstr, "!");
	for (i = 0; i < 16; i++) {
		sprintf(buf, "%02x", digest[i]);
		strcat(resultstr, buf);	    /* RATS: ignore (len OK) */
	}

	ptr = strdup(resultstr);

	if (ptr == NULL)
		abort();

	return ptr;
}

/* EOF */
