/***************************************************************************
 *   Copyright (C) 2006 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef EQSLIDER_H
#define EQSLIDER_H

#include <pixmapwidget.h>

/**
	@author Ilya Kotov <forkotov02@hotmail.ru>
*/
class QMouseEvent;
class QWheelEvent;

class Skin;

class EqSlider : public PixmapWidget
{
Q_OBJECT
public:
    EqSlider(QWidget *parent = 0);

    ~EqSlider();

    int value();

public slots:
    void setValue(int);
    void setMax(int);

signals:
    void sliderMoved (int);

private slots:
    void updateSkin();

private:
    Skin *m_skin;
    bool m_moving;
    int press_pos;
    int m_max, m_min, m_pos, m_value, m_old;
    QPixmap m_pixmap;
    int convert(int);   // value = convert(position);
    void draw(bool pressed = TRUE);

protected:
    void mousePressEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void wheelEvent(QWheelEvent *);


};

#endif
