########################################################################
#
# File:   suite.py
# Author: Mark Mitchell
# Date:   1/02/2004
#
# Contents:
#   QMTest ExplicitSuite class
#
# Copyright (c) 2004 by CodeSourcery, LLC.  All rights reserved. 
#
# For license terms see the file COPYING.
#
########################################################################

########################################################################
# Imports
########################################################################

from   qm.fields import BooleanField, SetField, TextField
import qm.test.suite

########################################################################
# Classes
########################################################################

class ExplicitSuite(qm.test.suite.Suite):
    """An 'ExplicitSuite' stores all of the test and suite ids explicitly."""

    arguments = [
        SetField(
            TextField(
                name = "test_ids",
                title = "Test Names",
                description = """The the tests contained in this suite.""")),
        SetField(
            TextField(
                name = "suite_ids",
                title = "Suite Names",
                description = """The the suites contained in this suite.""")),
        BooleanField(name = "is_implicit",
                     title = "Implicit?",
                     description = """,
                     True if this test is implicitly generated by QMTest.""",
                     default_value = "false"),
        ]
    
    def IsImplicit(self):

        return self.is_implicit == "true"
   

    def GetTestIds(self):
      
        return self.test_ids

   
    def GetSuiteIds(self):
      
        return self.suite_ids
