/***************************************************************************
 *   Copyright (C) 2007 by Matvey Kozhev                                   *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef DEVICE_H
#define DEVICE_H

#include <QString>
#include <QList>

/**
 @author Sikon <sikon@lucidfox.org>
*/
class Device
{
    int type;
    int port;
    QString model;
    
    unsigned short status;
    QMap<unsigned short, unsigned short> levels;

public:
    Device();
    Device(int type, int port, const QString& model);
    ~Device();
    
    int update();
    bool operator==(const Device& dev) const;
    operator QString() const                                    { return model; }
    
    static const Device& invalid;
    static void enumerate(QVector<Device> &list);
    
    unsigned short getStatus() const                            { return status; }
    int getInkLevel(unsigned short type) const;
    QString serialize() const;
    void deserialize(const QString& value);
    
private:
    void setInfo(const inklevel::ink_level& level);
};

#endif
