/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculatesetbasedialog.h"

#include <qradiobutton.h>
#include <qvbuttongroup.h>
#include <qspinbox.h>
#include <klocale.h>
#include <qvbox.h>

QalculateSetBaseDialog::QalculateSetBaseDialog(QWidget *parent, const char *name)
		: KDialogBase(parent, name, false, i18n("Number Bases"), Close, Close) {
	
	QHBox *box = makeHBoxMainWidget();

	radiogroup_output = new QVButtonGroup(i18n("Result Base"), box);
	radiogroup_output->setRadioButtonExclusive(true);
	new QRadioButton(i18n("Binary"), radiogroup_output);
	new QRadioButton(i18n("Octal"), radiogroup_output);
	new QRadioButton(i18n("Decimal"), radiogroup_output);
	new QRadioButton(i18n("Hexadecimal"), radiogroup_output);
	new QRadioButton(i18n("Other:"), radiogroup_output);
	outputBaseBox = new QSpinBox(2, 36, 1, radiogroup_output);
	outputBaseBox->setValue(10);
	new QRadioButton(i18n("Sexagesimal"), radiogroup_output);
	new QRadioButton(i18n("Time format"), radiogroup_output);
	new QRadioButton(i18n("Roman numerals"), radiogroup_output);

	radiogroup_input = new QVButtonGroup(i18n("Expression Base"), box);
	radiogroup_input->setRadioButtonExclusive(true);
	new QRadioButton(i18n("Binary"), radiogroup_input);
	new QRadioButton(i18n("Octal"), radiogroup_input);
	new QRadioButton(i18n("Decimal"), radiogroup_input);
	new QRadioButton(i18n("Hexadecimal"), radiogroup_input);
	new QRadioButton(i18n("Other:"), radiogroup_input);
	inputBaseBox = new QSpinBox(2, 36, 1, radiogroup_input);
	inputBaseBox->setValue(10);
	new QRadioButton(i18n("Roman numerals"), radiogroup_input);

}


QalculateSetBaseDialog::~QalculateSetBaseDialog() {}


#include "qalculatesetbasedialog.moc"
