/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculatesetbaseinexpressiondialog.h"

#include <qradiobutton.h>
#include <qvbuttongroup.h>
#include <qspinbox.h>
#include <klocale.h>
#include <qvbox.h>

QalculateSetBaseInExpressionDialog::QalculateSetBaseInExpressionDialog(QWidget *parent, const char *name)
		: KDialogBase(parent, name, false, i18n("Number Base (Expression)"), Close, Close) {
	radiogroup = new QVButtonGroup(makeVBoxMainWidget());
	radiogroup->setRadioButtonExclusive(true);
	new QRadioButton(i18n("Binary"), radiogroup);
	new QRadioButton(i18n("Octal"), radiogroup);
	new QRadioButton(i18n("Decimal"), radiogroup);
	new QRadioButton(i18n("Hexadecimal"), radiogroup);
	new QRadioButton(i18n("Other:"), radiogroup);
	baseBox = new QSpinBox(2, 36, 1, radiogroup);
	baseBox->setValue(10);
	new QRadioButton(i18n("Roman Numerals"), radiogroup);
}


QalculateSetBaseInExpressionDialog::~QalculateSetBaseInExpressionDialog() {}


#include "qalculatesetbaseinexpressiondialog.moc"
