# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002, 2003 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import copy
import threading

import events, hub, requests
import log
import network

from helper import debug

#
# songdb class
#

class songdb(threading.Thread):
    def __init__(self, id, server, port):
        threading.Thread.__init__(self)
        self.id = id
        self.server = server
        self.port = port
        self.remotesongdbid = "main"
        
        # as independent thread, we want our own event and request channel
        self.channel = hub.hub.newchannel()
        
        self.networkchannel = network.tcpclientchannel(self.server, self.port)
        #self.networkchannel.transmit(events.updatesong)
        #self.networkchannel.transmit(events.updatealbum)
        #self.networkchannel.transmit(events.updateartist)
        #self.networkchannel.transmit(events.playlistaddsong)
        self.networkchannel.start()

        # we need to be informed about database changes
        #self.channel.subscribe(events.updatesong, self.updatesong)
        #self.channel.subscribe(events.updatealbum, self.updatealbum)
        #self.channel.subscribe(events.updateartist, self.updateartist)
        #self.channel.subscribe(events.registersongs, self.registersongs)
        #self.channel.subscribe(events.registerplaylists, self.registerplaylists)
        self.channel.subscribe(events.quit, self.quit)
        
        self.done = 0
        
        # we are a database service provider...
        self.channel.supply(requests.dbrequest, self.dbrequest)
        log.info(_("database %s: type remote, hostname %s, port %d") % (self.id,
                                                                         self.server, self.port))

    def run(self):
        """main loop"""
        while not self.done:
            self.channel.process(blocking=1)

    def quit(self, event):
        self.done = 1

    # request handler

    def dbrequest(self, request):
        if self.id!=request.songdbid:
            raise hub.DenyRequest
        debug("dispatching %s\n" % `request`)
        if isinstance(request, requests.getdatabaseinfo):
            return ("remote", "%s:%d" % (self.server, self.port))
        # we have to copy the request, because another thread may also access it
        request = copy.copy(request)
        request.songdbid = self.remotesongdbid
        result = self.networkchannel.request(request)
        debug("result %s\n" % `result`)
        return result
