# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002, 2003 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import config
import item
import events, hub
import window

class iteminfowin(window.window):
    def __init__(self, screen, layout, channel, player):
        self.item = None
        self.player = player
        h, w, y, x, border = layout
        window.window.__init__(self, screen, h, w, y, x,
                               config.colors.iteminfowindow,
                               _("MP3 Info"), border)

        channel.subscribe(events.selectionchanged, self.selectionchanged)
        channel.subscribe(events.updatesong, self.updatesong)

    def resize(self, layout):
        h, w, y, x, self.border = layout
        window.window.resize(self, h, w, y, x)

    def update(self):
        # update window title
        if isinstance(self.item, item.song):
            if self.item.type=="mp3":
                self.settitle(_("MP3 Info"))
            else:
                self.settitle(_("Ogg Info"))
        else:
            self.settitle(_("Directory Info"))
        
        window.window.update(self)

        # get lines to display
        empty= [["", "", "", ""]]
        if self.item:
            info = self.item.getinfo()
        else:
            info = []
        l = info + empty*(4-len(info))
        
        colsep = self.iw>45

        # calculate width of columns
        wc1 = max( len(l[0][0]), len(l[1][0]), len(l[2][0]), len(l[3][0])) + colsep
        wc3 = max( len(l[0][2]), len(l[1][2]), len(l[2][2])) + colsep
        wc4 = 5
        wc2 = self.iw-wc1-wc3-wc4-1

        for lno in range(4):
            self.move(1+lno, self.ix)
            self.addstr(l[lno][0].ljust(wc1)[:wc1], self.colors.description)
            self.addstr(l[lno][1].ljust(wc2)[:wc2], self.colors.content)
            self.addch(" ")
            if lno!=3:
                self.addstr(l[lno][2].ljust(wc3)[:wc3], self.colors.description)
                self.addstr(l[lno][3].ljust(wc4)[:wc4], self.colors.content)
            else:
                # special handling of last line
                wc3 = max(len(l[3][-2]), 5) + colsep
                wc4 = max(len(l[3][-1]), 5)
                
                self.move(1+lno, self.iw-wc3-wc4-1-self.ix)
                self.addch(" ")
                self.addstr(l[3][-2].ljust(wc3)[:wc3], self.colors.description)
                self.addstr(l[3][-1].ljust(wc4)[:wc4], self.colors.content)

    # event handler
        
    def selectionchanged(self, event):
        if self.player and isinstance(event.item, item.song) and self.item!=event.item:
            hub.hub.notify(events.nextsong(self.player, event.item))
        self.item = event.item
        self.update()

    def updatesong(self, event):
        # needed only for songs, since these can be rated when they are played
        # note that this may update too often (if multiple songdbs are used),
        # but who cares.
        if isinstance(self.item, item.song) and event.song==self.item.song:
            self.update()
