#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
from distutils.core import setup, Extension
import sys; sys.path.append("src")
from version import version

# build extension module which adds transparency support for terminals
# supporting this feature (not necessary for Python 2.4 and above)
# You need the curses header files for building
buildcursext = 0

classifiers = ["Development Status :: 5 - Production/Stable",
               "Environment :: Console :: Curses",
               "Intended Audience :: End Users/Desktop",
               "License :: OSI Approved :: GNU General Public License (GPL)",
               "Programming Language :: Python",
               "Topic :: Multimedia :: Sound/Audio :: Players"]

if sys.version_info >= (2, 3):
    addargs = {"classifiers": classifiers}
else:
    addargs = {}

extmodules = [Extension("pytone.pcm", sources=["src/pcm/pcm.c"])]

if buildcursext:
    extmodules.append(Extension("pytone.cursext",
                                sources=["src/cursext/cursextmodule.c"],
                                libraries=["curses"]))

setup(name="PyTone",
      version=version,
      description="Powerful music jukebox with a curses based GUI.",
      author="Jrg Lehmann",
      author_email="joerg@luga.de",
      url="http://www.luga.de/pytone/",
      license="GPL",
      package_dir={"pytone": "src"},
      packages=["pytone", "pytone.services", "pytone.services.players", "pytone.services.songdbs"],
      ext_modules=extmodules,
      data_files=[('/usr/share/locale/de/LC_MESSAGES', ['locale/de/LC_MESSAGES/PyTone.mo',
                                                        'locale/it/LC_MESSAGES/PyTone.mo']),
                  ('/etc', ['conf/pytonerc']),
                  ('/usr/bin', ['pytone', 'pytonectl'])],
      **addargs
      )
