
"""
__version__ = "$Revision: 1.105 $"
__date__ = "$Date: 2004/04/11 15:15:10 $"
"""

import sys
import inspect

# KEA 2004-04-24
# wxPython 2.5.x workaround for Destroy() method
try:
    from wx.core import _wxPyDeadObject
except:
    _wxPyDeadObject = None

from wxPython import wx
import event
import error
import font
import graphic
import pom

#wx.wxCLIP_SIBLINGS = 0x20000000
MAGIC_GET_PREFIX = '_get'
MAGIC_SET_PREFIX = '_set'


class WidgetSpec(pom.ComponentSpec):
    def __init__(self):
        pom.ComponentSpec.__init__(self)
        
        self.name = 'Widget'
        self.parent = 'Component'
        self.parentName = self.parent
        self.events.extend( event.MOUSE_EVENTS )
        self._attributes.update({
            'id':{'presence':'optional', 'default':-1},
            'enabled' : { 'presence' : 'optional', 'default' : 1 },
            'visible' : { 'presence' : 'optional', 'default' : 1 },
            'foregroundColor' : { 'presence' : 'optional', 'default' : None },
            'backgroundColor' : { 'presence' : 'optional', 'default' : None },
            #'helpText' : { 'presence' : 'optional', 'default' : '' },
            'toolTip' : { 'presence' : 'optional', 'default' : '' },
            'font' : { 'presence' : 'optional', 'default' : None },
            'position' : { 'presence' : 'optional', 'default' : [ -1, -1 ] },
            'size' : { 'presence' : 'optional', 'default' : [ -1, -1 ] },
            'userdata' : {'presence':'optional', 'default':''}
        })

        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


# The meager beginnings of component object model. Maybe
# we could call it MOC, Model for Object Components.

# Example wrappers for GUI toolkit-specific widgets.

class Widget( pom.Component ) :
    """
    The base class for all of our GUI controls.

    Each Widget must bind itself to the wxPython
    event model.  When it receives an event
    from wxPython, it will convert the event
    to a PythonCArd event.Event ( SelectEvent, ClickEvent,
     etc ) and post the event to the EventQueue.
    """

    _spec = WidgetSpec()

    def __init__( self, aParent, aResource ) :
        # disabled '_helpText', 
        attributes = ['_command', '_font', '_id',
                      '_listeners', '_name', '_parent', '_userdata',
                      'this', 'thisown']
        self._createAttributes(attributes)
        pom.Component.__init__( self )
        self._parent = aParent
        try:
            self._id = aResource.id
            if self._id == -1:
                self._id = wx.wxNewId()
        except:
            self._id = wx.wxNewId()
        self._name = aResource.name

        # Get the class for a Widget (or Widget subclass) instance.
        selfClass = self.__class__
        # Assign several synonyms as Class attributes.
        if not hasattr(selfClass, '_getPosition'):
            selfClass._getPosition = selfClass.GetPositionTuple
        if not hasattr(selfClass, '_setPosition'):
            selfClass._setPosition = selfClass.Move
        if not hasattr(selfClass, '_getSize'):
            selfClass._getSize = selfClass.GetSizeTuple
        if not hasattr(selfClass, '_setSize'):
            selfClass._setSize = selfClass.SetSize
        if not hasattr(selfClass, '_getEnabled'):
            selfClass._getEnabled = selfClass.IsEnabled
        if not hasattr(selfClass, '_setEnabled'):
            selfClass._setEnabled = selfClass.Enable
        if not hasattr(selfClass, '_getVisible'):
            selfClass._getVisible = selfClass.IsShown
        if not hasattr(selfClass, '_setVisible'):
            selfClass._setVisible = selfClass.Show
        if not hasattr(selfClass, '_getForegroundColor'):
            selfClass._getForegroundColor = selfClass.GetForegroundColour
        if not hasattr(selfClass, '_getBackgroundColor'):
            selfClass._getBackgroundColor = selfClass.GetBackgroundColour

    def _postInit(self, aParent, aResource):
        ##self._delegate = self._createDelegate( aParent, aResource )
        self._bindEvents()        
        ##assert self._delegate is not None, 'null delegate! ' + self._name
        
        self._setUserdata(aResource.userdata)
        self._setCommand(aResource.command)
        # KEA 2004-04-23
        # controls are enabled and visible by default
        # so no need to enable and call Show unless False
        if not aResource.enabled:
            self._setEnabled(aResource.enabled)
        if not aResource.visible:
            self._setVisible(aResource.visible)
        if aResource.foregroundColor is not None:
            self._setForegroundColor(aResource.foregroundColor)
        if aResource.backgroundColor is not None:
            self._setBackgroundColor(aResource.backgroundColor)
        #self._setHelpText( aResource.helpText )
        if aResource.toolTip != "":
            self._setToolTip(aResource.toolTip)
        if aResource.font is None:
            self._font = None
        else:
            self._setFont(font.Font(aResource.font, self))
        # KEA 2002-02-12
        # these should be handled by __init__ so I don't see any
        # reason to set them again
        #self._setPosition( aResource.position )
        #self._setSize( aResource.size )

    def _getAttributeNames(self):
        """Return list of magic attributes to extend introspection.
        
        Returns only attributes having both "get" and "set" methods."""
        listX = []
        methods = inspect.getmembers(self, inspect.ismethod)
        for m in methods:
            if m[0].startswith(MAGIC_GET_PREFIX):
                name = m[0][len(MAGIC_GET_PREFIX):]
                if name and hasattr(self, MAGIC_SET_PREFIX + name):
                    listX.append(name[0].lower() + name[1:])
        return listX

    def __getattr__(self, name):
        if not name.startswith(MAGIC_GET_PREFIX) and name[0].islower():
            callName = MAGIC_GET_PREFIX + name[0].upper() + name[1:]
            return getattr(self, callName)()
        else:
            raise AttributeError, name

    def __setattr__(self, name, value):
        if name in self.__dict__:
            self.__dict__[name] = value
        elif not name.startswith(MAGIC_SET_PREFIX) and name[0].islower():
            callName = MAGIC_SET_PREFIX + name[0].upper() + name[1:]
            try:
                method = getattr(self, callName)
            except:
                raise AttributeError, name
            return method(value)
        elif name == '__class__' and value == _wxPyDeadObject:
            # KEA 2004-04-24
            # wxPython 2.5.x workaround for Destroy() method
            pass
        else:
            raise AttributeError, name
        
    def _createAttributes(self, attrList):
        for attr in attrList:
            if attr not in self.__dict__:
                self.__dict__[attr] = None

    ##def _createDelegate( self, aParent, aResource ) :
    ##    raise error.AbstractMethodException
    
    def _bindEvents( self ) :
        # KEA 2001-12-10
        #binding.EventBinding( self )
        raise error.AbstractMethodException


    #def _getDelegate( self ) :
    #    return self._delegate

    def __repr__(self):
        return str(self.__dict__)

    #def _getParent( self ) :
    #    return self._parent

    def getId(self):
        return self._id

    def _getId(self):
        return self._id

    def _setId(self, id):
        raise AttributeError, "id attribute is read-only"

    def _getName(self):
        return self._name 

    def _setName(self, aString):
        raise AttributeError, "name attribute is read-only"

    #def _getHelpText( self ) :
    #    return self._helpText
    
    def _getToolTip(self):
        try:
            t = self.GetToolTip().GetTip()
        except:
            # KEA 2002-04-25
            # WXMAC workaround
            t = ""
        return t
    
    def _getFont(self):
        if self._font is None:
            desc = font.fontDescription(self.GetFont())
            self._font = font.Font(desc)
        return self._font
    
    def _setForegroundColor( self, aColor ) :
        aColor = self._getDefaultColor( aColor )
        self.SetForegroundColour( aColor )
        self.Refresh()   # KEA wxPython bug?
    
    def _setBackgroundColor( self, aColor ) :
        aColor = self._getDefaultColor( aColor )
        self.SetBackgroundColour( aColor )
        self.Refresh()   # KEA wxPython bug?

    # KEA enabled, but it doesn't really do anything
    #def _setHelpText( self, aString ) :
    #    self._helpText = aString
        #self._delegate.SetHelpText( aString )
        
    def _setToolTip(self, aString):
        toolTip = wx.wxToolTip(aString)
        self.SetToolTip(toolTip)
    
    def _setFont(self, aFont):
        if isinstance(aFont, dict):
            aFont = font.Font(aFont, aParent=self)
        else: # Bind the font to this widget.
            aFont._parent = self
        self._font = aFont
        aWxFont = aFont._getFont()
        self.SetFont( aWxFont )

    def _getUserdata(self):
        return self._userdata 

    def _setUserdata(self, aString):
        self._userdata = aString

    def _setCommand( self, aString ) :
        self._command = aString

    def _getCommand( self ) :
        return self._command

    def _getDefaultColor( self, aColor ) :
        if aColor is None :
            return wx.wxNullColour
        else :
            # KEA 2001-07-27
            # is the right place for this check?
            if isinstance(aColor, tuple) and len(aColor) == 3:
                return wx.wxColour(aColor[0], aColor[1], aColor[2])
            else:
                return aColor

    def setFocus(self, aBoolean=1):
        if aBoolean:
            self.SetFocus()
        else:
            # looks like KillFocus() is gone in 2.3.2
            pass
            #self._delegate.KillFocus()


class Panel( wx.wxPanel ) :

    def __init__( self, aParent, imageFile, tiled ) :
        wx.wxPanel.__init__(self, aParent, -1, 
            style=wx.wxTAB_TRAVERSAL | wx.wxNO_FULL_REPAINT_ON_RESIZE)
        self._frame = aParent
        self._imageFile = imageFile
        self._backgroundTiling = tiled
        # KEA 2001-07-27
        # load the bitmap once and keep it around
        # this could fail, so should be a try/except
        if imageFile is not None :
            self._bitmap = graphic.Bitmap(imageFile)
            #self._backgroundTiling = 1  # KEA should be an attribute
            wx.EVT_ERASE_BACKGROUND( self, self.onEraseBackground )
        ##self._delegate = self

        wx.EVT_WINDOW_DESTROY(self, self._OnDestroy)

    def _OnDestroy(self, event):
        # memory leak cleanup
        self._bitmap = None

    def tileBackground(self, deviceContext):
        # tile the background bitmap
        sz = self.GetClientSize()
        bmp = self._bitmap.getBits()
        w = bmp.GetWidth()
        h = bmp.GetHeight()

        if isinstance(self, wx.wxScrolledWindow):
            # adjust for scrolled position
            spx, spy = self.GetScrollPixelsPerUnit()
            vsx, vsy = self.GetViewStart()
            dx,  dy  = (spx * vsx) % w, (spy * vsy) % h
        else:
            dx, dy = (w, h)

        x = -dx
        while x < sz.width:
            y = -dy
            while y < sz.height:
                # KEA 2004-01-25
                # wxPython 2.5 tuple change
                if wx.wxVERSION > (2, 5):
                    deviceContext.DrawBitmap(bmp, (x, y))
                else:
                    deviceContext.DrawBitmap(bmp, x, y)
                y = y + h
            x = x + w

    def getForegroundColor(self):
        return self.GetForegroundColour()

    def getBackgroundColor(self):
        return self.GetBackgroundColour()

    def _getDefaultColor(self, aColor):
        if aColor is None :
            return wx.wxNullColour
        else :
            # KEA 2001-07-27
            # is the right place for this check?
            if isinstance(aColor, tuple) and len(aColor) == 3:
                return wx.wxColour(aColor[0], aColor[1], aColor[2])
            else:
                return aColor
            
    def setForegroundColor(self, aColor):
        aColor = self._getDefaultColor(aColor)
        self.SetForegroundColour(aColor)
        self.Refresh()   # KEA wxPython bug?
    
    def setBackgroundColor(self, aColor):
        aColor = self._getDefaultColor(aColor)
        self.SetBackgroundColour(aColor)
        self.Refresh()   # KEA wxPython bug?

    def onEraseBackground(self, aWxEvent):
        deviceContext = aWxEvent.GetDC()
        if not deviceContext :
            deviceContext = wx.wxClientDC(self)
            r = self.GetUpdateRegion().GetBox()
            deviceContext.SetClippingRegion(r.x, r.y, r.width, r.height)
                                                       
        # KEA 2001-07-27
        # just loading the bitmap once in __init__, not each time
        # bitMap = Bitmap( self._imageFile )
        #deviceContext.DrawBitmap( bitMap.getBits(), 0, 0 )
        if self._backgroundTiling:
            self.tileBackground( deviceContext )
        else:
            if wx.wxVERSION > (2, 5):
                deviceContext.DrawBitmap(self._bitmap.getBits(), (0, 0))
            else:
                deviceContext.DrawBitmap(self._bitmap.getBits(), 0, 0)

    #def _getDelegate( self ) :
    #    return self._delegate




