
"""
__version__ = "$Revision: 1.5 $"
__date__ = "$Date: 2003/01/10 07:19:52 $"
"""

from PythonCardPrototype import log, model, res
import os
from wxPython import wx

NEWSTRING = 'newString'
SPACER = '  :  '

def stringResourceFromList(stringList):
    desc = "         {\n"

    for s in stringList:
        desc += """         %s:%s,\n""" % (repr(s), repr(stringList[s]))

    # close strings
    desc += "         }\n"
    d = eval(desc)
    return res.Resource(d)


class StringDialog(model.CustomDialog):
    def __init__(self, aBg, stringList):        
        model.CustomDialog.__init__(self, aBg)
        
        self.parent = aBg
        
        # if some special setup is necessary, do it here
        self.stringList = stringList
        sortedStrings = self.stringList.keys()
        sortedStrings.sort()
        for s in sortedStrings:
            label = s + SPACER + self.stringList[s].split('\n')[0]
            self.components.listStrings.append(label)

    def parseStrings(self, rsrc):
        stringList = {}
        for s in rsrc.__dict__:
            stringList[s] = rsrc.__dict__[s]
        return stringList

    def updateItemLabel(self, n, key):
        label = key + SPACER + self.stringList[key].split('\n')[0]
        self.components.listStrings.setString(n, label)

    def getStringSelectionKey(self):
        return self.components.listStrings.getStringSelection().split()[0]

    def on_fldName_closeField(self, event):
        newName = event.target.text
        #previousName = self.components.listStrings.getStringSelection()
        previousName = self.getStringSelectionKey()
        # if the name changes then we have to check to see
        # if the dictionary already has a key with the new
        # name
        if newName in self.stringList:
            # replace?
            pass
        else:
            sel = self.components.listStrings.selection
            self.stringList[newName] = self.stringList[previousName]
            del self.stringList[previousName]
            #self.components.listStrings.setString(sel, newName)
            self.updateItemLabel(sel, newName)

    def on_fldValue_closeField(self, event):
        sel = self.components.listStrings.selection
        #name = self.components.listStrings.getStringSelection()
        name = self.getStringSelectionKey()
        self.stringList[name] = event.target.text
        self.updateItemLabel(sel, name)

    def displayItemAttributes(self, s):
        self.components.fldName.text = s
        self.components.fldValue.text = self.stringList[s]

    def on_listStrings_select(self, event):
        #self.displayItemAttributes(event.target.getStringSelection())
        self.displayItemAttributes(self.getStringSelectionKey())
            
    def on_btnDelete_mouseClick(self, event):
        sel = self.components.listStrings.selection
        #name = self.components.listStrings.getStringSelection()
        name = self.getStringSelectionKey()
        if sel != -1:
            del self.stringList[name]
            self.components.listStrings.delete(sel)
            if len(self.stringList) > 0:
                if sel > len(self.stringList) - 1:
                    sel = sel - 1
                self.components.listStrings.selection = sel
                #self.displayItemAttributes(self.components.listStrings.getStringSelection())
                self.displayItemAttributes(self.getStringSelectionKey())

    def on_btnNew_mouseClick(self, event):
        s = NEWSTRING
        if s in self.stringList:
            self.components.listStrings.setStringSelection(s)
        else:
            self.stringList[s] = ''
            sel = len(self.stringList) - 1
            self.components.listStrings.append(s)
            self.components.listStrings.setStringSelection(s)
            self.updateItemLabel(sel, s)
        #self.displayItemAttributes(self.components.listStrings.getStringSelection())
        self.displayItemAttributes(self.getStringSelectionKey())

