
"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2004/03/17 17:58:16 $"
"""

#from wxPython import wx
import inspect

# these should be in some common place
# since they are used in widget.py as well
MAGIC_GET_PREFIX = '_get'
MAGIC_SET_PREFIX = '_set'



class StatusBar :

    def __init__( self, parent ) :
        attributes = ['_delegate', '_text']
        self._createAttributes(attributes)
        self._text = ''
        #self._delegate = wx.wxStatusBar(parent, wxNewId())
        self._delegate = parent.CreateStatusBar()


    def _getAttributeNames(self):
        """Return list of magic attributes to extend introspection.
        
        Returns only attributes having both "get" and "set" methods."""
        listX = []
        methods = inspect.getmembers(self, inspect.ismethod)
        for m in methods:
            if m[0].startswith(MAGIC_GET_PREFIX):
                name = m[0][len(MAGIC_GET_PREFIX):]
                if name and hasattr(self, MAGIC_SET_PREFIX + name):
                    listX.append(name[0].lower() + name[1:])
        return listX

    def __getattr__(self, name):
        if not name.startswith(MAGIC_GET_PREFIX) and name[0].islower():
            callName = MAGIC_GET_PREFIX + name[0].upper() + name[1:]
            return getattr(self, callName)()
        else:
            raise AttributeError, name

    def __setattr__(self, name, value):
        if name in self.__dict__:
            self.__dict__[name] = value
        elif not name.startswith(MAGIC_SET_PREFIX) and name[0].islower():
            callName = MAGIC_SET_PREFIX + name[0].upper() + name[1:]
            try:
                method = getattr(self, callName)
            except:
                raise AttributeError, name
            return method(value)
        else:
            raise AttributeError, name
        
    def _createAttributes(self, attrList):
        for attr in attrList:
            if attr not in self.__dict__:
                self.__dict__[attr] = None


    def _getText(self):
        return self._text

    def _setText(self, aString):
        self._text = aString
        self._delegate.SetStatusText(aString)
