"""
__version__ = "$Revision: 1.4 $"
__date__ = "$Date: 2002/04/21 23:05:21 $"
"""

from wxPython import wx
import sndhdr

class Sound:
    """
    Feeble beginnings of a class for playing sounds.
    The goal is to be able to provide a filename and then be able
    to play the sound without worrying about sound formats or particular
    OS capabilities. I haven't investigated the Python Standard Libraries
    much yet.
    """
    
    def __init__(self, filename) :
        self._filename = filename
        self._sndType = sndhdr.what(filename)
        if self._sndType:
            self._sndType = self._sndType[0]
        if self._sndType in ['wav']:
            try:
                self._sound = wx.wxWave(filename)    # support resources?
            except:
                self._sndType = None
        else:
            self._sndType = None
        if not self._sndType:
            raise

    def play(self, async=1, looped=0) :
        if self._sndType:
            self._sound.Play(async, looped)
