#!/usr/bin/python

"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2004/04/02 20:16:26 $"
"""

from PythonCardPrototype import model

from wxPython import wx

import os
import glob

from util import readLifeFile

class Patterns(model.Background):

    def on_openBackground(self, event):
        #self.initSizers()
        self.components.fldDescription.lineNumbersVisible = 0
        self.components.fldDescription.setEditorStyle('text')
        self.populatePatternsList()

    def initSizers(self):
        self.html = self.components.html
        self.html.SetRelatedFrame(self, "HTML Preview: %s")
        self.html.SetRelatedStatusBar(0)

        sizer1 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer1.Add(self.html, 1, wx.wxEXPAND)
        
        sizer1.Fit(self)
        sizer1.SetSizeHints(self)
        self.panel.SetSizer(sizer1)
        self.panel.SetAutoLayout(1)
        self.panel.Layout()

    def populatePatternsList(self):
        files = glob.glob(os.path.join(self.stack.app.applicationDirectory, 'patterns', '*.[Ll][Ii][Ff]'))
        items = []
        self.files = {}
        for file in files:
            filename = os.path.basename(file)
            base, ext = os.path.splitext(filename.lower())
            #items.append(base)
            self.files[base] = file
        items = self.files.keys()
        items.sort()
        self.components.lstPatterns.items = items
        self.components.lstPatterns.selection = 0
        # now simulate the user doing a selection
        self.on_lstPatterns_select(None)

    def loadPattern(self, name):
        #filename = name + '.lif'
        #path = os.path.join(self.stack.app.applicationDirectory, 'patterns', filename)
        try:
            path = self.files[name]
            #print num, path
            description, patterns, topLeft, size = readLifeFile(path)
            #print "topLeft:", topLeft, "size", size
            self.GetParent().initAndPlacePatterns(patterns, topLeft, size)
        except:
            pass

    def on_lstPatterns_select(self, event):
        #name = event.target.selected
        #filename = name + '.lif'
        #path = os.path.join(self.stack.app.applicationDirectory, 'patterns', filename)
        #path = self.files[event.target.selection]
        path = self.files[self.components.lstPatterns.selected]
        try:
            description, patterns, topLeft, size = readLifeFile(path)
            self.description = description
            self.patterns = patterns
            self.patternSize = size
            self.components.fldDescription.text = description
            self.components.stcSize.text = "Size: (%d, %d)" % size
        except:
            pass

    def on_btnLoad_mouseClick(self, event):
        self.loadPattern(self.components.lstPatterns.selected)

    def on_lstPatterns_mouseDoubleClick(self, event):
        self.loadPattern(self.components.lstPatterns.selected)

    def on_close(self, event):
        # KEA 2004-04-02
        # won't work until wxPython 2.5
        # self.visible = False
        self.Hide()
