#!/usr/bin/python

"""
__version__ = "$Revision: 1.18 $"
__date__ = "$Date: 2002/07/28 18:04:55 $"

flatfileDatabase was derived from the addresses sample.

"""

from PythonCardPrototype import flatfileDatabase, model
import os, sys
import ConfigParser

CONFIG_FILE = 'flatfileDatabase.ini'

class FlatfileDatabase(flatfileDatabase.FlatfileDatabase):
    def on_openBackground(self, event):
        # override the config filename
        self.configFilename = CONFIG_FILE
        flatfileDatabase.FlatfileDatabase.on_openBackground(self, event)

if __name__ == '__main__':
    # assume the ini file is in the same directory as the script
    path = os.path.join(os.path.dirname(sys.argv[0]), CONFIG_FILE)
    parser = ConfigParser.ConfigParser()
    parser.read(path)
    # the resourceFile is settable via the ini file
    resourceFile = parser.get('ConfigData', 'resourceFile')

    # KEA 2002-07-16
    # since all of the needed functionality is in the framework
    # classes, we don't have to subclass in this module, we can
    # just use the base class directly
    app = model.PythonCardApp(FlatfileDatabase, resourceFile)
    app.MainLoop()
