#!/usr/bin/python

"""
__version__ = "$Revision: 1.16 $"
__date__ = "$Date: 2002/12/30 23:40:20 $"

Note that there is a window refresh issue with the code below.
I'm setting a multiline static text field, which is dynamically
resizing the static text field to fit the content. If you resize
or hide the window then the text appears okay.
"""

import time
from PythonCardPrototype import dialog, model
import os, sys
from wxPython import wx
import minimalDialog

# KEA what kind of name conflicts do we need to watch for
# with the class name? the class was called Proof, but I renamed
# it Dialogs
class Dialogs(model.Background):

    def on_buttonMultipleChoice_mouseClick(self, event):
        result = dialog.multipleChoiceDialog(self, "title", "message", ['one', 'two', 'three'])
        self.components.fldResults.text = "multipleChoiceDialog result:\naccepted: %s\nSelection: %s" % (result['accepted'], result['selection'])

    def on_buttonSingleChoice_mouseClick(self, event):
        result = dialog.singleChoiceDialog(self, "title", "message", ['one', 'two', 'three'])
        self.components.fldResults.text = "singleChoiceDialog result:\naccepted: %s\nSelection: %s" % (result['accepted'], result['selection'])

    def on_buttonFind_mouseClick(self, event):
        result = dialog.findDialog(self)
        self.components.fldResults.text = "findDialog result:\naccepted: %s\nText: %s\nWhole word only: %s\nCase sensitive: %s" % (result['accepted'],
                                                                                                          result['searchText'],
                                                                                                          result['wholeWordsOnly'],
                                                                                                          result['caseSensitive'])

    def on_buttonColor_mouseClick(self, event):
        result = dialog.colorDialog(self)
        self.components.fldResults.text = "colorDialog result:\naccepted: %s\nColor: %s" % (result['accepted'], result['color'])

    def on_buttonFont_mouseClick(self, event):
        result = dialog.fontDialog(self)
        self.components.fldResults.text = "fontDialog result:\naccepted: %s\nColor: %s\nFont: %s" % (result['accepted'], result['color'], result['font'])

    def on_buttonFile_mouseClick(self, event):
        wildcard = "JPG files (*.jpg;*.jpeg)|*.jpeg;*.JPG;*.JPEG;*.jpg|GIF files (*.gif)|*.GIF;*.gif|All Files (*.*)|*.*"
        # wildcard = '*.py'
        result = dialog.fileDialog(self, 'Open', '', '', wildcard )
        self.components.fldResults.text = "fileDialog result:\naccepted: %s\npaths: %s" % (result['accepted'], result['paths'])

    def on_buttonOpenFile_mouseClick(self, event):
        wildcard = "JPG files (*.jpg;*.jpeg)|*.jpeg;*.JPG;*.JPEG;*.jpg|GIF files (*.gif)|*.GIF;*.gif|All Files (*.*)|*.*"
        # wildcard = '*.py'
        result = dialog.openFileDialog(wildcard=wildcard)
        self.components.fldResults.text = "openFileDialog result:\naccepted: %s\npaths: %s" % (result['accepted'], result['paths'])

    def on_buttonSaveFile_mouseClick(self, event):
        wildcard = "JPG files (*.jpg;*.jpeg)|*.jpeg;*.JPG;*.JPEG;*.jpg|GIF files (*.gif)|*.GIF;*.gif|All Files (*.*)|*.*"
        # wildcard = '*.py'
        result = dialog.saveFileDialog(wildcard=wildcard)
        self.components.fldResults.text = "saveFileDialog result:\naccepted: %s\npaths: %s" % (result['accepted'], result['paths'])

    def on_buttonDir_mouseClick(self, event):
        result = dialog.directoryDialog(self, 'Choose a directory', 'a')
        self.components.fldResults.text = "directoryDialog result:\naccepted: %s\npath: %s" % (result['accepted'], result['path'])

    """
    You can pass in a specific icon (default is ICON_INFORMATION)
    as well as the buttons (default is BUTTON_OK | BUTTON_CANCEL)
    
    ICON_EXCLAMATION    # Shows an exclamation mark icon.  
    ICON_HAND           # Shows an error icon.  
    ICON_ERROR          # Shows an error icon - the same as wxICON_HAND.  
    ICON_QUESTION       # Shows a question mark icon.  
    ICON_INFORMATION    # Shows an information (i) icon.

    BUTTON_OK           # Show an OK button.  
    BUTTON_CANCEL       # Show a Cancel button.  
    BUTTON_YES_NO       # Show Yes and No buttons.  
    BUTTON_YES_DEFAULT  # Used with wxYES_NO, makes Yes button the default - which is the default behaviour.  
    BUTTON_NO_DEFAULT   # Used with wxYES_NO, makes No button the default.  
    """
    def on_buttonMessage_mouseClick(self, event):
        """
        result = dialog.messageDialog(self, 'a message', 'a title',
                               dialog.ICON_ERROR, dialog.BUTTON_YES_NO)
        """
        result = dialog.messageDialog(self, 'a message', 'a title',
                               dialog.ICON_INFORMATION,
                               dialog.BUTTON_YES_NO | dialog.BUTTON_NO_DEFAULT | dialog.BUTTON_CANCEL)
        #result = dialog.messageDialog(self, 'a message', 'a title')
        self.components.fldResults.text = "messageDialog result:\naccepted: %s\nreturned: %s" % (result['accepted'], result['returned'])

    # you can pass in an additional aStyle parameter
    # of TEXT_PASSWORD or TEXT_MULTILINE
    def on_buttonTextEntry_mouseClick(self, event):
        result = dialog.textEntryDialog(self, 
                                    'A window title', 
                                    'What is your favorite language?',
                                    'Python')
        """
        result = dialog.textEntryDialog(self, 
                                    'A window title', 
                                    'What is your favorite language?',
                                    'Python', dialog.TEXT_MULTILINE)
        """
        self.components.fldResults.text = "textEntryDialog result:\naccepted: %s\nreturned: %s\ntext: %s" % (result['accepted'], result['returned'], result['text'])

    def on_buttonScrolledMessage_mouseClick(self, event):
        base, ext = os.path.splitext(os.path.split(sys.argv[0])[-1])
        filename = base + ".py"
        if os.path.exists(filename):
            f = open(filename, "r")
            msg = f.read()
        else:
            msg = "Can't find the file dialogs.py"
        result = dialog.scrolledMessageDialog(self, msg, filename)
        self.components.fldResults.text = "scrolledMessageDialog result:\naccepted: %s" % (result['accepted'])

    def on_buttonAlert_mouseClick(self, event):
        result = dialog.alertDialog(self, 'a message', 'a title')
        self.components.fldResults.text = "alertDialog result:\naccepted: %s\nreturned: %s" % (result['accepted'], result['returned'])

    def on_buttonMinimalDialog_mouseClick(self, event):
        result = minimalDialog.minimalDialog(self, 'hello minimal')
        self.components.fldResults.text = "minimalDialog result:\naccepted: %s\ntext: %s" % (result['accepted'], result['text'])

    def on_menuFileExit_select(self, event):
        self.Close()


if __name__ == '__main__':
    app = model.PythonCardApp(Dialogs)
    app.MainLoop()
