class ComponentRegistry :
    """
    Maintains a regstry of the PythonCard Components that have
    been loaded into the system.
    """

    def __init__( self ) :
        self.components = {}

    def register( self, componentClass ) :
        """
        Register a Component.
        """
        spec = componentClass._spec
        self.components[ spec.getName() ] = componentClass

    def hasComponent( self, name ) :
        """
        Return true if a Component matching 'name' exists
        in the registry.
        """
        return name in self.components

    def getComponents( self ) :
        """
        Get a dictionary that contains all of the 
        registered Components.
        """
        return self.components

    def getComponentClass( self, name ) :
        """
        Get the class object for a named Component.
        """
        return self.components[ name ]

    def getComponentSpec( self, name ) :
        """
        Get the Spec object for a named Component.
        """
        return self.getComponentClass( name )._spec

_registry = ComponentRegistry()

def getRegistry() :
    """
    Global access to the single registry instance.
    """
    return _registry

