"""
__version__ = "$Revision: 1.25 $"
__date__ = "$Date: 2004/04/07 20:37:23 $"
"""

import sys
from wxPython import wx
import dispatch
import res
import event
import pom

"""
KEA 2003-08-02

Need to test adding, renaming, deleting, a menuitem or menu
once the application is running. In particular, I'm curious about
doing dynamic menus for adding Scriptlets or allowing the user
to override accelerator key bindings.

Also, probably need to refactor so that we just use wxPython methods
when possible and get rid of the extra lists and duplicate method
calls.

The exception are any name related utility routines that make it
simpler to modify menu items and menus based on name rather than
a fixed id.

Also need to make sure a wxMenu can be created for use as a popup menu
and then have it be destroyed correctly. See fpop sample.

Can debug.py have its menu handled via the new menu classes? That is
can we add the Debug menu dynamically. Maybe not because of the event
binding.
"""

class MenuItem(wx.wxMenuItem, pom.Component):
    """
    A MenuItem represents one selectable item in a Menu.

    A MenuItem with the name '-' is interpreted as
    a  separator.
    """

    def __init__(self, aScriptable, aParent, aResource):
        self.name = aResource.name
        self.label = aResource.label
        self.command = aResource.command
        self.checkable = aResource.checkable
        self.enabled = aResource.enabled
        self.checked = aResource.checked

        id =  wx.wxNewId()

        if aResource.label == '-':
            wx.wxMenuItem.__init__(self, aParent, wx.wxID_SEPARATOR, kind=wx.wxITEM_SEPARATOR)
        elif aResource.checkable:
            #print aResource.label, aResource.checked, aResource.checked==True
            wx.wxMenuItem.__init__(self, aParent, id, aResource.label, "", kind=wx.wxITEM_CHECK)
            # must use wxCallAfter to avoid init problems
            # if this ends up causing another conflict with openBackground...
            # then I guess we could drop the wxMenuItem sub-class and
            # just use wxMenu.Append like we used to
            if aResource.checked:
                wx.wxCallAfter(self.Check, aResource.checked)
            if not aResource.enabled:
                wx.wxCallAfter(self.Enable, aResource.enabled)
        else:
            #print aResource.label
            wx.wxMenuItem.__init__(self, aParent, id, aResource.label, "")
            if not aResource.enabled:
                wx.wxCallAfter(self.Enable, aResource.enabled)

        # events are bound to the parent wxFrame
        # aka aParent.parent.parent
        wx.EVT_MENU(aScriptable, id, aParent.parent.doMenu)

        pom.Component.__init__( self )

        dispatch.EventDispatch(self, aScriptable)

        aParent.parent.id2itemMap[id] = self


    def _getName( self ) :
        return self.name

    def getLabel( self ) :
        return self.label

    def getCommand( self ) :
        return self.command

    def getCheckable( self ) :
        return self.checkable

    def getEnabled( self ) :
        return self.enabled

    def getChecked( self ) :
        return self.checked

    def setName( self, aString ) :
        self.name = aString
             
    def setLabel( self, aString ) :
        self.label = aString

    def setCommand( self, aString ) :
        self.command = aString

    def __repr__( self ) :
        return 'MenuItem=' + str( self.__dict__ )


class Menu(wx.wxMenu):
    """
    A Menu contains 0..n MenuItem objects.
    """

    def __init__(self, aParent, aResource):
        wx.wxMenu.__init__(self)

        self.parent = aParent
        self.name = aResource.name
        self.label = aResource.label
        self.enabled = aResource.enabled
        self.items = []

        for itemRsrc in aResource.items:
            menuItem = MenuItem(aParent.parent, self, itemRsrc)
            self.appendMenuItem(menuItem)


##    def parseMenuItems( self, aParent, aResource ) :
##        for item in aResource :
##            self.appendMenuItem( MenuItem( aParent, item ) )

    def _getName( self ) :
        return self.name

    def getLabel( self ) :
        return self.label

    def getEnabled( self ) :
        return self.enabled

    def appendMenuItem(self, aMenuItem):
        # self.items is for backwards compatability
        self.items.append(aMenuItem)
        self.AppendItem(aMenuItem)

    def insertMenuItem( self, aMenuItem, aIndex ) :
        pass

    def deleteMenuItem( self, aName ) :
        pass

    def getMenuItem( self, aName ) :
        pass

    def getMenuItemByIndex( self, aIndex ) :
        pass

    def enable( self ) :
        pass

    def disable( self ) :
        pass

    def getMenuItems( self ) :
        return self.items

    def __repr__( self ) :
        return 'Menu=' + str( self.__dict__ )


class MenuBar(wx.wxMenuBar):

    def __init__(self, aParent, aMenuBarRsrc):
        wx.wxMenuBar.__init__(self)
        
        self.parent = aParent
        self.menus = []
        #self.parseMenus(aParent, aMenuBarRsrc.menus)

        self.id2itemMap = {}
        enabledMenus = []
        #menus = self.getMenus()

        # KEA 2003-08-02
        # menus probably needs to be a UserList subclass
        # so that menus can be treated as a Python list, but
        # automatically do wxMenuBar.Append... as needed
        # alternatively, the helper methods
        # would just get ids and such dynamically from the menubar
        # using wxPython methods
        for menuRsrc in aMenuBarRsrc.menus:
            menu = Menu(self, menuRsrc)
            self.menus.append(menu)
            self.Append(menu, menu.getLabel())
            enabledMenus.append(menu.getEnabled())

        aParent.SetMenuBar(self)
        # this is a complete hack because we don't have the id of the Menu
        for i in range(0, len(enabledMenus)):
            if not enabledMenus[i]:
                self.EnableTop(i, 0)

    def doMenu( self, aWxMenuEvent ) :
        id = aWxMenuEvent.GetId()
        #if id in self.id2cmdMap:
        #    command = self.id2cmdMap[ id ]
        #    if command is None :
        #        evt = MenuEvent( self.id2nameMap[ id ], self )
        #    else  :

        item = self.id2itemMap[ id ]
        if item.getCommand() is not None :
            evt = event.CommandEvent( item.getCommand(), item )
        else :
            evt = event.SelectEvent( item )
        # KEA 2002-03-07
        # change to (self, event) event handler dispatch
        # add target manually since this is a custom event
        # and doesn't go through normal dispatch
        aWxMenuEvent.target = self.id2itemMap[id]
        aWxMenuEvent.eventObject = aWxMenuEvent.target
        try:
            aWxMenuEvent.checked = aWxMenuEvent.IsChecked()
        except:
            pass
        #aWxMenuEvent.target = aWxMenuEvent.GetEventObject()

        # KEA 2001-12-03
        # added missing setNativeEvent
        evt.setNativeEvent(aWxMenuEvent)
        item._notifyEventListeners(evt)
       
##    def parseMenus(self, aParent, aResource):
##        for menu in aResource:
##            self.menus.append(Menu(aParent, menu))

    def __repr__(self):
        return 'MenuBar=' + str(self.__dict__)

    def appendMenu( self, aMenu ) :
        pass

    def insertMenu( self, aMenu, aIndex ) :
        pass

    def deleteMenu( self, aName ) :
        pass

    def getMenu( self, aName ) :
        pass

    def getMenuByIndex( self, aIndex ) :
        pass

    def getMenuId(self, aString):
        id = -1
        for m in self.menus:
            menuLabel = m.label.strip('&')
            if m.name == aString:
                id = self.FindMenu(menuLabel)
                break
            for mi in m.items:
                if mi.name == aString:
                    menuItemLabel = mi.label.split('\t')[0].strip('&')
                    id = self.FindMenuItem(menuLabel, menuItemLabel)
                    break
        return id

    # KEA 2004-04-07
    # Rowland suggests that the methods below be separated for release 0.8
    # so that separate methods are used for menus and menu items
    
    def getChecked( self, aString):
        id = self.getMenuId(aString)
        if id == -1:
            # KEA 2004-04-07
            # should we throw an exception here to indicate the menu/menu item wasn't found?
            return -1
        else:
            return self.IsChecked(id)

    def getEnabled( self, aString):
        id = self.getMenuId(aString)
        if id == -1:
            # KEA 2004-04-07
            # should we throw an exception here to indicate the menu/menu item wasn't found?
            return -1
        else:
            return self.IsEnabled(id)

    def setChecked( self, aString, aBoolean=True):
        # KEA 2004-04-07
        # if aString is a menu name instead of a menuItem name
        # and there is a match then an exception will be thrown below
        # when Check is called
        id = self.getMenuId(aString)
        if id == -1:
            # KEA 2004-04-07
            # should we throw an exception here to indicate the 
            # menu/menu item wasn't found instead of failing silently?
            pass
        else:
            self.Check(id, aBoolean)

    def setEnabled( self, aString, aBoolean=1) :
        i = 0
        for m in self.menus:
            menuLabel = m.label.strip('&')
            if m.name == aString:
                self.EnableTop(i, aBoolean)
                break
            for mi in m.items:
                if mi.name == aString:
                    menuItemLabel = mi.label.split('\t')[0].strip('&')
                    id = self.FindMenuItem(menuLabel, menuItemLabel)
                    self.Enable(id, aBoolean)
                    break
            i += 1

    def getMenus( self ) :
        return self.menus

    # KEA 2003-08-02
    # why don't these do anything?!
    # go ahead and add the code so they are functional
    def enableCommand( self, aString ) :
        for item in self.id2itemMap.itervalues() :
            if item.getCommand() is aString :
                print 'enabling menu item', item.getName()
                pass

    def disableCommand( self, aString ) :
        for item in self.id2itemMap.itervalues() :
            if item.getCommand() is aString :
                print 'disabling menu item', item.getName()
                pass


# Unit Test

if __name__ == '__main__' :
    resource = res.ResourceFile( sys.argv[ 1 ] ).getResource()



