
"""
__version__ = "$Revision: 1.13 $"
__date__ = "$Date: 2004/03/23 20:48:27 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget
import textfield


class TextAreaSpec(textfield.TextFieldSpec):
    def __init__(self):
        textfield.TextFieldSpec.__init__(self)
        
        self.name = 'TextArea'
        self.parent = 'TextField'
        self.parentName = self.parent
        # KEA 2002-03-02
        # if the TextEnterEvent is added to TextField
        # it should probably be removed from the event list here
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class TextArea(textfield.TextField):
    """
    A text area that can have multi-line text, scrollbars, etc..
    """

    _spec = TextAreaSpec()

    def __init__( self, aParent,  aResource ) :
        ##textfield.TextField.__init__( self, aParent, aResource )
        attributes = ['_border', '_alignment']
        self._createAttributes(attributes)
        self._border = aResource.border
        widget.Widget.__init__( self, aParent, aResource )

        # previously _createDelegate would be called by Widget.__init__
        # so put wxTextCtrl.__init__ here
        if aResource.border == 'none':
            borderStyle = wx.wxNO_BORDER
        else:
            borderStyle = 0

        self._alignment = aResource.alignment

        try:
            # if we're using a version of wxPython after 2.3.2.1
            # try and use RichEdit2
            richText = wx.wxTE_RICH2
        except:
            richText = wx.wxTE_RICH

        wx.wxTextCtrl.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.text, 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ),
            style =  richText | wx.wxTE_PROCESS_TAB | wx.wxTE_MULTILINE | borderStyle | \
                textfield.getAlignment(aResource.alignment) | \
                wx.wxNO_FULL_REPAINT_ON_RESIZE | wx.wxCLIP_SIBLINGS,
            name = aResource.name )

        # we don't call TextField.__init__ so this duplicate code is required
        if not hasattr(self.__class__, '_getText'):
            self.__class__._getText = self.__class__.GetValue
        if not hasattr(self.__class__, '_setText'):
            self.__class__._setText = self.__class__.SetValue
        if not hasattr(self.__class__, '_getEditable'):
            self.__class__._getEditable = self.__class__.IsEditable
        if not hasattr(self.__class__, '_setEditable'):
            self.__class__._setEditable = self.__class__.SetEditable

        self._setEditable( aResource.editable )

        if aResource.border == 'none':
            self.SetBackgroundColour(self.GetParent().GetBackgroundColour())

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    # KEA 2004-04-23
    # workaround for wxPython 2.4.x and 2.5.x
    # returning text with \r instead of \n
    if wx.wxPlatform == '__WXMAC__':
        def _getText(self):
            return self.GetValue().replace('\r', '\n')

    def _bindEvents(self):
        adapter = textfield.TextFieldEventBinding(self)
        adapter.bindEvents()


registry.getRegistry().register( sys.modules[__name__].TextArea )
