
"""
__version__ = "$Revision: 1.12 $"
__date__ = "$Date: 2004/03/31 01:36:12 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class ListSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'List'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.SelectEvent])
        self._attributes.update({ 
            'items' : { 'presence' : 'optional', 'default' : [] },
            'selected' : { 'presence' : 'optional', 'default' : None } 
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class List(widget.Widget, wx.wxListBox):
    """
    A list that only allows a single item to be selected.
    """
    
    _spec = ListSpec()

    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxListBox.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            aResource.items,
            style = wx.wxLB_SINGLE | wx.wxCLIP_SIBLINGS,
            name = aResource.name )

        if aResource.selected != "" and aResource.selected :
            self._setSelection( aResource.selected )

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)
    
    def _bindEvents(self):
        adapter = ListEventBinding(self)
        adapter.bindEvents()

    def _getItems(self):
        delegate = self
        items = []
        for i in range(delegate.GetCount()):
            items.append(delegate.GetString(i))
        return items

    # KEA fixed setValue
    # there should be more flexibility than clearing the whole list
    # and replacing it with a new one
    def _setItems( self, aList ) :
        #self._delegate.setValue( aList )
        #self.Clear()
        #self.InsertItems( aList, 0 )
        # KEA 2003-07-26
        # I'm just now realizing I could have been using Set
        self.Set(aList)

    # KEA this either needs to be renamed
    # so that we can set the selection via string and
    # position or handle it with an if statement in the existing method
    # the same goes for getSelection
    # wxPython has GetSelection/SetSelection for an integer position
    # and GetStringSelection/SetStringSelection for strings
    # I think we should go with those names
    def _setSelection(self, s, select=1):
        if s is None:
            return
        elif isinstance(s, int):
            self.SetSelection(s, select)
        else:
            self.SetStringSelection(s, select)

    # KEA this is redundant, may remove it later
    def setStringSelection(self, s, select=1):
        self.SetStringSelection(s, select)
        
    def getSelectionIndex( self ) :
        return self.GetSelection()

    # KEA change in behavior to mimic wxPython
    def _getSelection( self ) :
        # Bug in wxPython? self._delegate.GetStringSelection()
        #i = self.getSelectionIndex()
        #return self._delegate.GetString( i )
        return self.GetSelection()

    def getSelections( self ) :
        return self.GetSelections()

    def getStringSelection( self ) :
        return self.GetStringSelection()

    # KEA more wxListBox methods

    def append( self, aString ) :
        self.Append( aString )

    def clear( self ) :
        self.Clear()

    def delete( self, aPosition ) :
        self.Delete( aPosition )

    def findString( self, aString ) :
        return self.FindString( aString )

    def getString( self, aPosition ) :
        return self.GetString( aPosition )

    def insertItems( self, aList, aPosition ) :
        self.InsertItems( aList, aPosition )

    # KEA this should probably have a different name
    # KEA 2004-03-30, obsolete in wxPython 2.5 and will be removed in PythonCard
    def getNumber( self ) :
        return self.GetCount()

    def getCount(self):
        return self.GetCount()

    # KEA was getSelected
    def _isSelected( self, aPosition ) :
        """Determines whether an item is selected.
        aPosition is the zero-based item index
        Returns 1 if the given item is selected, 0 otherwise.
        """
        return self.Selected( )

    # KEA 2001-08-14
    # temporary fix
    # naming of selected, selection, stringSelection, etc. needs to be clarified
    # and standardized across List, RadioGroup, Choice
    # and then spec.py, debug.py, etc. needs to be updated

    def _getSelected( self ) :
        return self.GetStringSelection( )

    def _setSelected( self, aString ) :
        self.setStringSelection(aString)

    def setString( self, n, aString ) :
        self.SetString( n, aString )


class ListEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.List to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

    """
    Bind an Event class that is supported by this objects peer Widget.
    """
    def bindEvent( self, aEventClass ) :
        parent = self._component._parent
        id = self._component.getId()
        if aEventClass is event.SelectEvent :
            wx.EVT_LISTBOX( parent, id, self._dispatch )

        if aEventClass is event.MouseDoubleClickEvent :
            wx.EVT_LISTBOX_DCLICK( parent, id, self._dispatch )
    """
    Intercept all wxPyton events, convert them to PythonCard events, and
    post them to the EventQueue.
    """
    def _dispatch( self, aWxEvent ) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return

        evt = None 

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_LISTBOX_SELECTED :
            evt = self._createEvent( event.SelectEvent, aWxEvent )

        elif aWxEvent.GetEventType() == wx.wxEVT_COMMAND_LISTBOX_DOUBLECLICKED :
            evt = self._createEvent( event.MouseDoubleClickEvent, aWxEvent )

        if evt is not None :
            self._component._notifyEventListeners( evt )


registry.getRegistry().register( sys.modules[__name__].List )

