
"""
__version__ = "$Revision: 1.4 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

if wx.wxPlatform == '__WXMSW__':
    from wxPython import iewin

# need a graceful exit

import sys
from PythonCardPrototype import binding, event, log, registry, widget

class IEHtmlWindowSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'IEHtmlWindow'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.IEHtmlTitleChangeEvent,
                            event.IEHtmlStatusTextChangeEvent,
                            event.IEHtmlDocumentCompleteEvent,
                            ])
        self._attributes.update({
            'text' : { 'presence' : 'optional', 'default' : '' },
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()
       

class IEHtmlWindow(widget.Widget, iewin.wxIEHtmlWin):
    """
    An HTML window using the MS HTML control.
    """

    _spec = IEHtmlWindowSpec()

    def __init__(self, aParent, aResource):
        widget.Widget.__init__(self, aParent, aResource)

        iewin.wxIEHtmlWin.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint(aResource.position[0], aResource.position[1]), 
            wx.wxSize(aResource.size[0], aResource.size[1]),
            style = wx.wxCLIP_SIBLINGS | wx.wxNO_FULL_REPAINT_ON_RESIZE,
            name = aResource.name 
        )

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        self._setText(aResource.text)

    # KEA 2003-01-03
    # should this just go away with 2.3.4.2 and above
    # Refresh was renamed to RefreshPage in wxIEHtmlWin
    def Refresh(self, *_args):
        if _args:
            iewin.wxIEHtmlWin.Refresh(self, _args[0])

    def _bindEvents(self):
        adapter = IEHtmlWindowEventBinding(self)
        adapter.bindEvents()

    def _getText(self) :
        #return self.GetOpenedPage()
        return self.GetText()

    def _setText(self, aString):
        if aString == '' or aString[0] == '<':
            self.LoadString(aString)
        else:
            # filename or URL
            self.LoadUrl(aString)


class IEHtmlWindowEventBinding(binding.wxPython_EventBinding):
    """
    Bind the Events supported by event.Button to wxPython.
    """
    def __init__(self, aComponent):
        binding.wxPython_EventBinding.__init__(self, aComponent)

    def bindEvent(self, aEventClass):
        parent = self._component._parent
        if aEventClass is event.IEHtmlTitleChangeEvent:
            iewin.EVT_MSHTML_TITLECHANGE(parent, self._component.getId(), self._dispatch)
        elif aEventClass is event.IEHtmlStatusTextChangeEvent:
            iewin.EVT_MSHTML_STATUSTEXTCHANGE(parent, self._component.getId(), self._dispatch)
        elif aEventClass is event.IEHtmlDocumentCompleteEvent:
            iewin.EVT_MSHTML_DOCUMENTCOMPLETE(parent, self._component.getId(), self._dispatch)

    def _dispatch(self, aWxEvent):
        component = self._component 

        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch(self, aWxEvent):
            return

        evt = None

        if aWxEvent.GetEventType() == iewin.wxEVT_COMMAND_MSHTML_TITLECHANGE:
            evt = self._createEvent(event.IEHtmlTitleChangeEvent, aWxEvent)
        elif aWxEvent.GetEventType() == iewin.wxEVT_COMMAND_MSHTML_STATUSTEXTCHANGE:
            evt = self._createEvent(event.IEHtmlStatusTextChangeEvent, aWxEvent)
        elif aWxEvent.GetEventType() == iewin.wxEVT_COMMAND_MSHTML_DOCUMENTCOMPLETE:
            evt = self._createEvent(event.IEHtmlDocumentCompleteEvent, aWxEvent)

        if evt is not None:
            component._notifyEventListeners(evt)

registry.getRegistry().register( sys.modules[__name__].IEHtmlWindow )

