
"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx, calendar
import sys
from PythonCardPrototype import binding, event, registry, widget


class CalendarSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Calendar'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.CalendarMouseDoubleClickEvent,
                            event.CalendarChangedEvent,
                            event.CalendarDayEvent,
                            event.CalendarMonthEvent,
                            event.CalendarYearEvent,
                            event.CalendarWeekDayHeaderEvent,
                            ])
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Calendar(widget.Widget, calendar.wxCalendarCtrl):

    _spec = CalendarSpec()

    def __init__(self, aParent,  aResource):
        widget.Widget.__init__(self, aParent, aResource)
        
        # previously _createDelegate would be called by Widget.__init__
        # so put wxCalendarCtrl.__init__ here
        calendar.wxCalendarCtrl.__init__(self,
                    aParent,
                    self.getId(),
                    wx.wxDateTime_Now(),
                    wx.wxPoint(aResource.position[0], aResource.position[1]),
                    wx.wxSize(aResource.size[0], aResource.size[1]),
                    style = wx.wxCLIP_SIBLINGS |
                                         calendar.wxCAL_SHOW_HOLIDAYS |
                                         calendar.wxCAL_SHOW_SURROUNDING_WEEKS,
                                         #calendar.wxCAL_SEQUENTIAL_MONTH_SELECTION,
                    name = aResource.name
                   )

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        # workaround for calendar init and GetPosition/SetPosition
        self.SetPosition((aResource.position[0], aResource.position[1]))
        
        #if aResource.default:
        #    self._setDefault(1)

    def _bindEvents(self):
        adapter = CalendarEventBinding(self)
        adapter.bindEvents()

    # KEA 2002-07-09
    # use same name as wxPython calendar module
    def SetNow(self):
        self.SetDate(wx.wxDateTime_Now())

class CalendarEventBinding(binding.wxPython_EventBinding):

    def __init__(self, aComponent):
        binding.wxPython_EventBinding.__init__(self, aComponent)

    def bindEvent(self, aEventClass):
        parent = self._component._parent
        id = self._component.getId()
        if aEventClass is event.CalendarMouseDoubleClickEvent:
            calendar.EVT_CALENDAR(parent, id, self._dispatch)
        elif aEventClass is event.CalendarChangedEvent:
            calendar.EVT_CALENDAR_SEL_CHANGED(parent, id, self._dispatch)
        elif aEventClass is event.CalendarDayEvent:
            calendar.EVT_CALENDAR_DAY(parent, id, self._dispatch)
        elif aEventClass is event.CalendarMonthEvent:
            calendar.EVT_CALENDAR_MONTH(parent, id, self._dispatch)
        elif aEventClass is event.CalendarYearEvent:
            calendar.EVT_CALENDAR_YEAR(parent, id, self._dispatch)
        elif aEventClass is event.CalendarWeekDayHeaderEvent:
            calendar.EVT_CALENDAR_WEEKDAY_CLICKED(parent, id, self._dispatch)

    def _dispatch(self, aWxEvent):
        component = self._component 

        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch(self, aWxEvent):
            return

        evt = None

        eventType = aWxEvent.GetEventType()
        if eventType == calendar.wxEVT_CALENDAR_DOUBLECLICKED:
            evt = self._createEvent(event.CalendarMouseDoubleClickEvent, aWxEvent)
        elif eventType == calendar.wxEVT_CALENDAR_SEL_CHANGED:
            evt = self._createEvent(event.CalendarChangedEvent, aWxEvent)
        elif eventType == calendar.wxEVT_CALENDAR_DAY_CHANGED:
            evt = self._createEvent(event.CalendarDayEvent, aWxEvent)
        elif eventType == calendar.wxEVT_CALENDAR_MONTH_CHANGED:
            evt = self._createEvent(event.CalendarMonthEvent, aWxEvent)
        elif eventType == calendar.wxEVT_CALENDAR_YEAR_CHANGED:
            evt = self._createEvent(event.CalendarYearEvent, aWxEvent)
        elif eventType == calendar.wxEVT_CALENDAR_WEEKDAY_CLICKED:
            evt = self._createEvent(event.CalendarWeekDayHeaderEvent, aWxEvent)

        if evt is not None:
            component._notifyEventListeners(evt)



# KEA 2001-12-09
# the registry could contain a dictionary of the class, its EventBinding, spec, etc.
# some of those references could be class attributes instead
# it seems like the spec for the class should be part of the class itself
# RDS 2001-16-01
# A new module, registry, contains the ComponentRegistry class.  A Component's
# class now contains it's spec, which contains meta data for it's events
# and attributes.  Components register with the ComponentRegistry.

registry.getRegistry().register(sys.modules[__name__].Calendar)
