#
# Copyright (c) 2002, 2003, 2004 Art Haas
#
# This file is part of PythonCAD.
# 
# PythonCAD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# PythonCAD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with PythonCAD; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# functions for doing mirroring operations
#

import pygtk
pygtk.require('2.0')
import gtk

import Generic.hcline
import Generic.acline
import Generic.vcline
import Generic.cline

import Generic.mirror as mirror

def mirror_objects(gtkimage, tool, objs):
    _mline = tool.getMirrorLine()
    if len(objs):
        gtkimage.startAction()
        try:
            _mobjs = mirror.mirror_objects(gtkimage, _mline, objs)
        finally:
            gtkimage.endAction()
    gtkimage.redraw()
    gtkimage.setPrompt("Click on the mirroring construction line.")
    tool.reset()
    mirror_mode_init(tool)
    
def select_motion_notify(gtkimage, widget, event, tool):
    _tx, _ty = tool.getLocation()
    _px, _py = gtkimage.coordToPixTransform(_tx, _ty)
    _gc = gtkimage.getGC()
    _x = int(event.x)
    _y = int(event.y)
    _cp = tool.getCurrentPoint()
    if _cp is not None:
        _xc, _yc = _cp
        _xmin = min(_xc, _px)
        _ymin = min(_yc, _py)
        _rw = abs(_xc - _px)
        _rh = abs(_yc - _py)
        widget.window.draw_rectangle(_gc, gtk.FALSE, _xmin, _ymin, _rw, _rh)
    tool.setCurrentPoint(_x, _y)
    _xmin = min(_x, _px)
    _ymin = min(_y, _py)
    _rw = abs(_x - _px)
    _rh = abs(_y - _py)
    widget.window.draw_rectangle(_gc, gtk.FALSE, _xmin, _ymin, _rw, _rh)

def second_button_press_cb(gtkimage, widget, event, tool):
    _x, _y = gtkimage.getPoint()
    _tol = gtkimage.getTolerance()
    _active_layer = gtkimage.getActiveLayer()
    _p = _active_layer.find('point', _x, _y)
    if _p is not None:
        _x, _y = _p.getCoords()
    _x1, _y1 = tool.getLocation()
    _xmin = min(_x1, _x)
    _ymin = min(_y1, _y)
    _xmax = max(_x1, _x)
    _ymax = max(_y1, _y)
    _objs = _active_layer.objsInRegion(_xmin, _ymin, _xmax, _ymax, True)
    mirror_objects(gtkimage, tool, _objs)

def first_button_press_cb(gtkimage, widget, event, tool):
    _x, _y = gtkimage.getPoint()
    _tol = gtkimage.getTolerance()
    _objdict = gtkimage.mapPoint(_x, _y, _tol)
    if len(_objdict):
        _active_layer = gtkimage.getActiveLayer()
        if _active_layer in _objdict:
            _objs = []
            for _obj, _pt in _objdict[_active_layer]:
                _objs.append(_obj)
            _mline = tool.getMirrorLine()
            mirror_objects(gtkimage, tool, _objs)
    else:
        _p, _flag = gtkimage.findPoint(_x, _y, _tol)
        if _p is not None:
            _x, _y = _p.getCoords()
        tool.setLocation(_x, _y)
        tool.setHandler("motion_notify", select_motion_notify)
        tool.setHandler("button_press", second_button_press_cb)
        gtkimage.getGC().set_function(gtk.gdk.INVERT)        
        
def get_mirror_line_cb(gtkimage, widget, event, tool):
    _x, _y = gtkimage.getPoint()
    _tol = gtkimage.getTolerance()
    _objdict = gtkimage.mapPoint(_x, _y, _tol)
    if len(_objdict):
        _active_layer = gtkimage.getActiveLayer()
        _got_line = False
        if _active_layer in _objdict:
            for _obj, _pt in _objdict[_active_layer]:
                if isinstance(_obj, (Generic.hcline.HCLine,
                                     Generic.vcline.VCLine,
                                     Generic.acline.ACLine,
                                     Generic.cline.CLine)):
                    tool.setHandler("button_press", first_button_press_cb)
                    tool.setMirrorLine(_obj)
                    gtkimage.setPrompt("Click on the objects to mirror.")
                    break

def mirror_mode_init(tool):
    tool.setHandler("button_press", get_mirror_line_cb)
