#
# Copyright (c) 2002, 2003, 2004 Art Haas
#
# This file is part of PythonCAD.
# 
# PythonCAD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# PythonCAD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with PythonCAD; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Deleting objects
#

import Generic.point
import Generic.circle
import Generic.arc
import Generic.conobject
import Generic.hcline
import Generic.vcline
import Generic.acline
import Generic.segjoint
import Generic.cline
import Generic.ccircle
import Generic.leader
import Generic.polyline
import Generic.text
import Generic.dimension

def delete_objects(layer, objlist):
    """Remove a list of objects from a Layer.

delete_objects(objlist)

The objlist argument must be a list containing objects stored
within the layer.
    """
    if not isinstance(objlist, list):
        raise TypeError, "Invalid object list: " + `objlist`
    for _obj in objlist:
        _lobj = layer.findObject(_obj)
        if _lobj is not _obj:
            raise ValueError, "Object not found in layer: " + `_obj`
    _objdict = {}
    for _obj in objlist:
        _objdict[id(_obj)] = True
    for _obj in objlist:
        if isinstance(_obj, Generic.point.Point):
            continue
        elif isinstance(_obj, Generic.segment.Segment):
            _p1, _p2 = _obj.getEndpoints()
            _pid = id(_p1)
            if _pid in _objdict:
                _objdict[_pid] = False
            _pid = id(_p2)
            if _pid in _objdict:
                _objdict[_pid] = False
        elif isinstance(_obj, Generic.arc.Arc):
            _cp = _obj.getCenter()
            _pid = id(_cp)
            if _pid in _objdict:
                _objdict[_pid] = False
            for _ep in _obj.getEndpoints():
                _lp = layer.find('point', _ep[0], _ep[1])
                assert _lp is not None, "Missing arc endpoint:" + str(_ep)
                _pid = id(_lp)
                if _pid in _objdict:
                    _objdict[_pid] = False
        elif isinstance(_obj, (Generic.circle.Circle,
                               Generic.ccircle.CCircle)):
            _cp = _obj.getCenter()
            _pid = id(_cp)
            if _pid in _objdict:
                _objdict[_pid] = False
        elif isinstance(_obj, (Generic.hcline.HCLine,
                               Generic.vcline.VCLine,
                               Generic.acline.ACLine)):
            _lp = _obj.getLocation()
            _pid = id(_lp)
            if _pid in _objdict:
                _objdict[_pid] = False
        elif isinstance(_obj, Generic.cline.CLine):
            _p1, _p2 = _obj.getKeypoints()
            _pid = id(_p1)
            if _pid in _objdict:
                _objdict[_pid] = False
            _pid = id(_p2)
            if _pid in _objdict:
                _objdict[_pid] = False
        elif isinstance(_obj, (Generic.segjoint.Chamfer,
                               Generic.segjoint.Fillet)):
            continue # chamfers/fillets do not delete attached segments
        elif isinstance(_obj, (Generic.leader.Leader,
                               Generic.polyline.Polyline)):
            for _pt in _obj.getPoints():
                _pid = id(_pt)
                if _pid in _objdict:
                    _objdict[_pid] = False
        elif isinstance(_obj, Generic.text.TextBlock):
            continue
        else:
            pass
    for _obj in objlist:
        if _objdict[id(_obj)]:
            layer.delObject(_obj)
