#ifndef VISUAL_AXIAL_H
#define VISUAL_AXIAL_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "prim.h"

namespace visual {

class axialSymmetry : public Primitive 
{
	// axialSymmetry primitives define the radius and length attributes,
	//   but not height or width.

public:
	axialSymmetry() : radius(1.0) {}
	axialSymmetry( const axialSymmetry& other) 
		: Primitive(other), radius( other.radius) 
	{}
	
	inline double 
	get_radius() const 
	{ return radius; }
	
	void set_radius( const double& r);
	
	inline double 
	get_length() 
	{ return axis.mag(); }
	
	void set_length( const double& l);
	virtual vector getScale();
	
protected:
	double radius;
};

} // !namespace visual

#endif // !VISUAL_AXIAL_H
