# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class NumberTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.pricing.v2.numbers("+15017122661").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://pricing.twilio.com/v2/Trunking/Numbers/+15017122661',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "country": "United States",
                "destination_number": "+18001234567",
                "originating_call_price": {
                    "base_price": null,
                    "current_price": null,
                    "number_type": null
                },
                "iso_country": "US",
                "origination_number": null,
                "terminating_prefix_prices": [
                    {
                        "base_price": null,
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1800"
                        ],
                        "friendly_name": "Trunking Outbound Minute - United States Zone 1b",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    }
                ],
                "price_unit": "USD",
                "url": "https://pricing.twilio.com/v2/Trunking/Numbers/+18001234567"
            }
            '''
        ))

        actual = self.client.pricing.v2.numbers("+15017122661").fetch()

        self.assertIsNotNone(actual)

    def test_fetch_with_origination_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "country": "United States",
                "destination_number": "+18001234567",
                "originating_call_price": {
                    "base_price": null,
                    "current_price": "0.013",
                    "number_type": "tollfree"
                },
                "iso_country": "US",
                "origination_number": "+15105556789",
                "terminating_prefix_prices": [
                    {
                        "base_price": null,
                        "current_price": "0.001",
                        "destination_prefixes": [
                            "1800"
                        ],
                        "friendly_name": "Trunking Outbound Minute - United States - Toll Free",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    }
                ],
                "price_unit": "USD",
                "url": "https://pricing.twilio.com/v2/Trunking/Numbers/+18001234567"
            }
            '''
        ))

        actual = self.client.pricing.v2.numbers("+15017122661").fetch()

        self.assertIsNotNone(actual)
