#!/usr/bin/env python
""" bank06: Simulate several customers arriving
            at random, using a Source
"""
from __future__ import generators
from SimPy.Simulation  import *
from random import Random                      

class Source(Process):
    """ Source generates customers randomly"""
    def __init__(self,seed=333):               
        Process.__init__(self)
        self.SEED = seed                       

    def generate(self,number,interval):       
        rv = Random(self.SEED)                 
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,))
            activate(c,c.visit(timeInBank=12.0))
            t = rv.expovariate(1.0/interval)   
            yield hold,self,t                  

class Customer(Process):
    """ Customer arrives, looks round and leaves """
    def __init__(self,name):
        Process.__init__(self)
        self.name = name
        
    def visit(self,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        yield hold,self,timeInBank
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():
    initialize()
    source=Source(seed = 99999)                  
    activate(source,source.generate(5,10.0),0.0) 
    simulate(until=400.0)

model()
