#!/usr/bin/env python
""" bank07: Simulate customers arriving
            at random, using a Source
            requesting service from a clerk.
"""
from __future__ import generators
from SimPy.Simulation  import *
from random import Random

class Source(Process):
    """ Source generates customers randomly"""
    def __init__(self,seed=333):
        Process.__init__(self)
        self.SEED = seed

    def generate(self,number,interval):       
        rv = Random(self.SEED)
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,))
            activate(c,c.visit(timeInBank=12.0))
            t = rv.expovariate(1.0/interval)
            yield hold,self,t

class Customer(Process):
    """ Customer arrives, is served and  leaves """
    def __init__(self,name):
        Process.__init__(self)
        self.name = name
        
    def visit(self,timeInBank=0):       
        arrive=now()                            
        print "%7.4f %s: Here I am     "%(now(),self.name)
        yield request,self,counter              
        wait=now()-arrive                       
        print "%7.4f %s: Waited %6.3f"%(now(),self.name,wait)
        yield hold,self,timeInBank
        yield release,self,counter               
        print "%7.4f %s: Finished      "%(now(),self.name)

def model():
    global counter                               
    counter = Resource(name="Karen")             
    initialize()
    source=Source(seed = 99999)
    activate(source,source.generate(5,10.0),0.0) 
    simulate(until=400.0)

model()
