#!/usr/bin/env python
""" bank01: Simulate several customers using a Source """
from __future__ import generators
from SimPy.Simulation  import *

class Source(Process):                          
    """ Source generates customers regularly"""
    def __init__(self):                         
        Process.__init__(self)                  

    def generate(self,number,interval):         
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,))
            activate(c,c.visit(timeInBank=12.0))
            yield hold,self,interval            

class Customer(Process):
    """ Customer arrives, looks round and leaves """
    def __init__(self,name):
        Process.__init__(self)
        self.name = name
        
    def visit(self,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        yield hold,self,timeInBank
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():
    initialize()
    source=Source()                              
    activate(source,source.generate(5,10.0),0.0) 
    simulate(until=400.0)

model()
 
