from typing import Dict, List, NamedTuple, Union

from pyproj.enums import PJType

def get_proj_operations_map() -> Dict[str, str]: ...
def get_ellps_map() -> Dict[str, Dict[str, float]]: ...
def get_prime_meridians_map() -> Dict[str, str]: ...

class Unit(NamedTuple):
    id: str
    to_meter: str
    name: str
    factor: float

def get_units_map() -> Dict[str, Unit]: ...
def get_angular_units_map() -> Dict[str, Unit]: ...
def get_authorities() -> List[str]: ...
def get_codes(
    auth_name: str, pj_type: Union[PJType, str], allow_deprecated: bool = False
) -> List[str]: ...
