Thanks for your interest in contributing to pipx!

## Running pipx From Source Tree
To run the pipx executable from your source tree during development, run pipx from the src directory:

```
python src/pipx --version
```

## Pre-commit
The use of [pre-commit](https://pre-commit.com/) is recommended.  It can show
all and fix some lint errors before commit, saving you the trouble of finding
out later that it failed CI Lint errors, and saving you from having to run `nox
-s lint` separately.

In the pipx git repository is a `.pre-commit-config.yaml` configuration file
tailored just for pipx and its lint requirements.  To use pre-commit in your
clone of the pipx repository, you need to do the following **one-time setup
procedure**:

1. Install pre-commit using `pipx install pre-commit`
2. In the top level directory of your clone of the pipx repository, execute `pre-commit install`

Afterwards whenever you commit in this repository, it will first run pipx's
personalized lint checks.  If it makes a fix to a file (e.g. using `black` or
`isort`), you will need to `git add` that file again before committing it
again.  If it can't fix your commit itself, it will tell you what's wrong, and
you can fix it manually before re-adding the edited files and committing again.

If for some reason you want to commit and skip running pre-commit, you can use
the switch `git commit --no-verify`.

## Running Tests

### Setup
pipx uses an automation tool called [nox](https://pypi.org/project/nox/) for development, continuous integration testing, and various tasks.

`nox` defines tasks or "sessions" in `noxfile.py` which can be run with `nox -s SESSION_NAME`. Session names can be listed with `nox -l`.

Install nox for pipx development:
```
python -m pip install --user nox
```

Tests are defined as `nox` sessions. You can see all nox sessions with
```
nox -l
```

At the time of this writing, the output looks like this
```
>> nox -l
Sessions defined in /home/csmith/git/pipx/noxfile.py:

* tests-3.6
* tests-3.7
* tests-3.8
* tests-3.9
- cover -> Coverage analysis
* lint
- develop-3.6
- develop-3.7
- develop-3.8
- develop-3.9
- build
- publish
* build_docs
- publish_docs
- watch_docs
- pre_release
- post_release
```

### Unit Tests
To run unit tests in Python3.9, you can run
```
nox -s tests-3.9
```

!!! tip
    You can run a specific unit test by passing arguments to pytest, the test runner pipx uses:

    ```
    nox -s tests-3.8 -- -k EXPRESSION
    ```

    `EXPRESSION` can be a test name, such as

    ```
    nox -s tests-3.8 -- -k test_uninstall
    ```

    Coverage errors can usually be ignored when only running a subset of tests.

### Lint Tests

```
nox -s lint
```

## Testing pipx on Continuous Integration builds
When you push a new git branch, tests will automatically be run against your code as defined in `.github/workflows/on-push.yml`.

## Building Documentation

`pipx` autogenerates API documentation, and also uses templates.

When updating pipx docs, make sure you are either modifying a file in the `templates` directory, or the `docs` directory. If in the `docs` directory, make sure the file was not autogenerated from the `templates` directory. Autogenerated files have a note at the top of the file.

You can generate the documentation with
```
nox -s build_docs
```

This will capture CLI documentation for any pipx argument modifications, as well as generate templates to the docs directory.

To preview changes, including live reloading, open another terminal and run
```
nox -s watch_docs
```

### Publishing Doc Changes to GitHub pages
```
nox -s publish_docs
```

## Releasing New `pipx` Versions
### Pre-release

First, make sure the changelog is complete.  Next decide what the next version
number will be.  Then, from a clone of the main pipxproject pipx repo (not a
fork) execute:
```
nox -s pre_release
```

Enter the new version number when asked. When the script is finished, check the
diff it produces.  If the diff looks correct, commit the changes as the
script instructs, and push the result.

The script will modify `src/pipx/version.py` to contain the new version, and
also update the changelog (`docs/changelog.md`) to specify the new version.

### Release
To publish to PyPI simply create a "published" release on Github.  This will
trigger Github workflows that both publish the pipx version to PyPI and publish
the pipx documentation to the pipx website.

### Post-release
From a clone of the main pipxproject pipx repo (not a
fork) execute:
```
nox -s post_release
```

When the script is finished, check the diff it produces.  If the diff looks
correct, commit the changes as the script instructs, and push the result.

This will update pipx's version in `src/pipx/version.py` by adding a suffix
`"dev0"` for unreleased development, and will update the changelog to start a
new section at the top entitled `dev`.
