#!/usr/bin/env python

import sys, os
import re
from distutils.core import setup

if sys.hexversion >= 0x02030000:
    sys.stderr.write("warning: Optik not needed for Python 2.3 or later "
                     "(use optparse instead)\n")

version = None
initpy = open(os.path.join("lib", "__init__.py"), "rt")
for line in initpy:
    match = re.match(r'^__version__ = "([^"]+)"', line)
    if match:
        version = match.group(1)
        break
if not version:
    sys.exit("error: could not determine version from %s" % initpy)
initpy.close()

# patch distutils if it can't cope with the "classifiers" or
# "download_url" keywords
if sys.hexversion < 0x02020300:
    from distutils.dist import DistributionMetadata
    DistributionMetadata.classifiers = None
    DistributionMetadata.download_url = None

setup(name = "optik",
      version = version,
      author = "Greg Ward",
      author_email = "gward@python.net",
      url = "http://optik.sourceforge.net/",
      download_url = "http://sourceforge.net/project/showfiles.php?group_id=38019",
      description = "Powerful, flexible, easy-to-use, command-line parsing library",
      long_description = """\
Optik is a powerful, flexible, extensible, easy-to-use
command-line parsing library for Python.  Using Optik, you
can add intelligent, sophisticated handling of command-line
options to your scripts with very little overhead.""",
      license = "BSD",

      classifiers = [
          "Development Status :: 5 - Production/Stable",
          "Environment :: Console",
          "Intended Audience :: Developers",
          "License :: OSI Approved :: BSD License",
          "Operating System :: OS Independent",
          "Programming Language :: Python",
          "Topic :: Software Development",
          ],

      package_dir = { "optik" : "lib", "": os.curdir },
      packages = ["optik", ""],
     )
