# an object which constrains the motion of a camera within its bounds
from ogltex import *

class Camroom(Box):
    def __init__(self, location = (0,0,0),dim = (1,1,1)):
        Box.__init__(self,'Images/cowbaby.ppm',location,dim)
        #walls can be approached to within c
        c = dim[2]/10.0        
        #camera constraint
        self.bounds = ((location[0]-dim[0]+c,location[0]+dim[0]-c),(location[1]-dim[1]+c, location[1]+dim[1]-c),(location[2]-dim[2]+c,location[2]+dim[2]-c))

    def ok_to_move_to(self,location):
        print self.bounds
        if location[0] < self.bounds[0][0]: return(0)
        if location[0] > self.bounds[0][1]: return(0)
        if location[1] < self.bounds[1][0]: return(0)
        if location[1] > self.bounds[1][1]: return(0)
        if location[2] < self.bounds[2][0]: return(0)
        if location[2] > self.bounds[2][1]: return(0)
        return(1)
