"""TODO:
 * COOKIEFILE is not a valid indication for successfull authentication,
   use connection.needs_login instead
"""
import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored, SkipSuiteError

import launchpadbugs.exceptions as exceptions
from launchpadbugs.connector import ConnectBug
from launchpadbugs.bugbase import Bug
from launchpadbugs.lpconstants import HTTPCONNECTION

COOKIEFILE = ConfigTest()["test_examples"]["cookiefile"]

PRODUCT = {"name": "buglog-data"}
SUMMARY = "[testbug] auto-created by python-launchpad-bugs"
DESCRIPTION = """This bug was auto-created by python-launchpad-bugs
PLEASE do not modify this bugreport.
Thanks"""
TAGS = ["foo","bar"]

TestBug = None




class HTMLBugTestCase(PyLPBugsTestCase):
    """ creating and parsing bugreports in html mode """    
        
    def test_001_1_create_no_cookie(self):
        """[STABLE] Try to create a bugreport without beeing logged in"""
        HBug = ConnectBug()
        HBug.set_connection_mode(HTTPCONNECTION.MODE.STABLE)
        if not HBug.connection.needs_login():
            raise TestCaseIgnored, "logged in"
        self.failUnlessRaises(exceptions.LaunchpadLoginError, HBug.New,
                                    product=PRODUCT, summary=SUMMARY, description=DESCRIPTION)
        
    def test_001_2_create_no_cookie(self):
        """[EDGE] Try to create a bugreport without beeing logged in"""
        HBug = ConnectBug()
        HBug.set_connection_mode(HTTPCONNECTION.MODE.EDGE)
        if not HBug.connection.needs_login():
            raise TestCaseIgnored, "logged in"
        self.failUnlessRaises(exceptions.LaunchpadLoginError, HBug.New,
                                    product=PRODUCT, summary=SUMMARY, description=DESCRIPTION)
                                    
    def test_002_1_create_wrong_product(self):
        """[STABLE] Try to create a Bugreport with invalid product"""
        if COOKIEFILE:
            HBug = ConnectBug()
            HBug.authentication = COOKIEFILE
            HBug.set_connection_mode(HTTPCONNECTION.MODE.STABLE)
            if HBug.connection.needs_login():
                raise TestCaseIgnored, "authentication failed"
            self.failUnlessRaises(exceptions.PythonLaunchpadBugsValueError, HBug.New,
                                        product=PRODUCT, summary="", description="")
            try:
                HBug.New(product={"name": "bazbar", "target":"foobar"}, summary="", description="")
            except exceptions.PythonLaunchpadBugsValueError, e:
                self.assert_(str(e) == """There is a problem with the information you entered.  Please fix it and try again.
Maybe there is no product 'bazbar' in the distribution 'foobar'""")
        else:
            raise TestCaseIgnored, "no cookie file given"
                                    
    def test_002_2_create_wrong_product(self):
        """[EDGE] Try to create a Bugreport with invalid product"""
        if COOKIEFILE:
            HBug = ConnectBug()
            HBug.authentication = COOKIEFILE
            HBug.set_connection_mode(HTTPCONNECTION.MODE.EDGE)
            if HBug.connection.needs_login():
                raise TestCaseIgnored, "authentication failed"
            self.failUnlessRaises(exceptions.PythonLaunchpadBugsValueError, HBug.New,
                                        product=PRODUCT, summary="", description="")
            try:
                HBug.New(product={"name": "bazbar", "target":"foobar"}, summary="", description="")
            except exceptions.PythonLaunchpadBugsValueError, e:
                self.assert_(str(e) == """There is a problem with the information you entered.  Please fix it and try again.
Maybe there is no product 'bazbar' in the distribution 'foobar'""")
        else:
            raise TestCaseIgnored, "no cookie file given"
                                    
    def test_003_1_create_wrong_arguments(self):
        """[STABLE] Try to create a Bugreport with invalid arguments"""
        if COOKIEFILE:
            HBug = ConnectBug()
            HBug.authentication = COOKIEFILE
            HBug.set_connection_mode(HTTPCONNECTION.MODE.STABLE)
            if HBug.connection.needs_login():
                raise TestCaseIgnored, "authentication failed"
            self.failUnlessRaises(exceptions.PythonLaunchpadBugsValueError, HBug.New,
                                        product=PRODUCT, summary="", description="")
            try:
                HBug.New(product=PRODUCT, summary="", description="")
            except exceptions.PythonLaunchpadBugsValueError, e:
                self.assert_(str(e) == """There is a problem with the information you entered.  Please fix it and try again.
There are 2 errors
    * field.title: Required input is missing.
    * field.comment: Required input is missing.""")
        else:
            raise TestCaseIgnored, "no cookie file given"
                                    
    def test_003_2_create_wrong_arguments(self):
        """[EDGE] Try to create a Bugreport with invalid arguments"""
        if COOKIEFILE:
            HBug = ConnectBug()
            HBug.authentication = COOKIEFILE
            HBug.set_connection_mode(HTTPCONNECTION.MODE.EDGE)
            if HBug.connection.needs_login():
                raise TestCaseIgnored, "authentication failed"
            self.failUnlessRaises(exceptions.PythonLaunchpadBugsValueError, HBug.New,
                                        product=PRODUCT, summary="", description="")
            try:
                HBug.New(product=PRODUCT, summary="", description="")
            except exceptions.PythonLaunchpadBugsValueError, e:
                self.assert_(str(e) == """There is a problem with the information you entered.  Please fix it and try again.
There are 2 errors
    * field.title: Required input is missing.
    * field.comment: Required input is missing.""")
        else:
            raise TestCaseIgnored, "no cookie file given"
                                    
    def test_004_read_bugreport(self):
        """[STABLE/EDGE] read a Bugreport as a backup if no new bugreport is created"""
        HBug_stable = ConnectBug()
        HBug_edge = ConnectBug()
        HBug_stable.set_connection_mode(HTTPCONNECTION.MODE.STABLE)
        HBug_edge.set_connection_mode(HTTPCONNECTION.MODE.EDGE)
        global TestBug
        TestBug = {"STABLE": HBug_stable(248976), "EDGE": HBug_edge(248976)}
                                    
    def test_005_create(self):
        """[STABLE/EDGE] Create a Bugreport"""
        tests_done = False
        global TestBug
        con = {"STABLE": ConnectBug(), "EDGE": ConnectBug()}
        con["STABLE"].set_connection_mode(HTTPCONNECTION.MODE.STABLE)
        con["EDGE"].set_connection_mode(HTTPCONNECTION.MODE.EDGE)
        for k, i in con.iteritems():
            if COOKIEFILE:
                i.authentication = COOKIEFILE
            if i.connection.needs_login():
                continue
            TestBug[k] = i.New(product=PRODUCT, summary=SUMMARY, description=DESCRIPTION, tags=TAGS)
            self.assert_(isinstance(TestBug[k], Bug), "instance test failed in mode '%s'" %k)
            tests_done = True
        if not tests_done:
            raise TestCaseIgnored, "no cookie file given"
        self.description = " (%s) " %", ".join(i.url for i in TestBug.values())
        
    def test_006_get_basics(self):
        """[STABLE/EDGE] Get basic attributes like url, bugnumber, repr"""
        for k, i in TestBug.iteritems():
            x = i.bugnumber
            self.assert_(isinstance(x, int), "bugnumber, failed in mode '%s'" %k)
            self.assert_(repr(i) == "<Bug %s>" %x, "repr, failed in mode '%s'" %k)
            self.assert_(hasattr(i, "url"), "url, failed in mode '%s'" %k)
            if k == "STABLE":
                self.assert_skip("bugs.launchpad.net" in i.url.lower(), "url failed in mode '%s': %s" %(k, i.url))
            else:
                self.assert_skip("bugs.edge.launchpad.net" in i.url.lower(), "url failed in mode '%s': %s" %(k, i.url))
        
    def test_007_get_title(self):
        """[STABLE/EDGE] get title"""
        for k, i in TestBug.iteritems():
            self.assert_(i.title == SUMMARY, "unable to get .title in mode '%s'" %k)
        
    def test_008_get_description(self):
        """[STABLE/EDGE] get description"""
        for k, i in TestBug.iteritems():
            self.assert_(i.description == DESCRIPTION, "unable to get .description in mode '%s'" %k)
        
    def test_009_get_description_raw(self):
        """[STABLE/EDGE] get description_raw"""
        if COOKIEFILE:
            for k, i in TestBug.iteritems():
                self.assert_(isinstance(i.description_raw, str), "unable to get .description_raw in mode '%s'" %k)
        else:
            raise TestCaseIgnored, "No cookiefile given, can not get .description_raw when not logged into launchpad.net"
        
    def test_010_get_tags(self):
        """[STABLE/EDGE] get tags"""
        for k, i in TestBug.iteritems():
            self.assert_(isinstance(i.tags,list), "wrong type of .tags in mode '%s'" %k)
            self.assert_(set(i.tags) == set(TAGS), "unable to get .tags in mode '%s'" %k)
        
    def test_011_get_nickname(self):
        """[STABLE/EDGE] get nickname"""
        for k, i in TestBug.iteritems():
            self.assert_(not i.nickname, "unable to get .nickname in mode '%s'" %k)
        
    def test_012_get_target(self):
        """[STABLE/EDGE] get target"""
        for k, i in TestBug.iteritems():
            self.assert_(i.target == PRODUCT.get("target",None), "unable to get .nickname in mode '%s'" %k)
        
    def test_013_get_sourcepackage(self):
        """[STABLE/EDGE] get sourcepackage"""
        for k, i in TestBug.iteritems():
            self.assert_(i.sourcepackage == PRODUCT.get("name",None), "unable to get .nickname in mode '%s'" %k)
        
    def test_014_get_reporter(self):
        """[STABLE/EDGE] get reporter"""
        from launchpadbugs.lphelper import user
        for k, i in TestBug.iteritems():
            self.assert_(isinstance(i.reporter, user), "wrong type of .reporter in mode '%s'" %k)
        
    def test_015_get_date(self):
        """[STABLE/EDGE] get date"""
        from launchpadbugs.lptime import LPTime
        for k, i in TestBug.iteritems():
            self.assert_(isinstance(i.date, LPTime), "wrong type of .date in mode '%s'" %k)
        
    def test_016_get_info(self):
        """[STABLE/EDGE] get info"""
        from launchpadbugs.tasksbase import LPTask
        for k, i in TestBug.iteritems():
            self.assert_(isinstance(i.info, LPTask), "wrong type of .info in mode '%s'" %k)
            self.assert_(i.status == "New", "wrong status in mode '%s'" %k)
            self.assert_(i.importance == "Undecided", "wrong importance in mode '%s'" %k)
            self.assert_(not i.assignee, "wrong assignee in mode '%s'" %k)
        
    def test_017_1_edit_task(self):
        """[STABLE] edit task, status and assignee"""
        b = TestBug["STABLE"]
        self.assert_skip("bugs.launchpad.net" in b.url.lower(), " wrong url %s" %b.url)
        if COOKIEFILE:
            b.assignee = "hkjaljksdfhajsldfjaljksdfjkaksdklf"
            #TODO: change this to PyLPBugsValueError
            self.failUnlessRaises(ValueError, b.commit, False, False)
            b.assignee = "thekorn"
            b.status = "Invalid"
            self.failIfRaises(Exception, b.commit, False, False)
        else:
            raise TestCaseIgnored, "no cookie file given"
        
    def test_017_2_edit_task(self):
        """[EDGE] edit task, status and assignee"""
        b = TestBug["EDGE"]
        self.assert_skip("bugs.edge.launchpad.net" in b.url.lower(), " wrong url %s" %b.url)
        if COOKIEFILE:
            b.assignee = "hkjaljksdfhajsldfjaljksdfjkaksdklf"
            #TODO: change this to PyLPBugsValueError
            self.failUnlessRaises(ValueError, b.commit, False, False)
            b.assignee = "thekorn"
            b.status = "Invalid"
            self.failIfRaises(Exception, b.commit, False, False)
        else:
            raise TestCaseIgnored, "no cookie file given"
                    
        
if __name__ == '__main__':
    import unittest
    
    HTMLBugTestSuite = unittest.TestLoader().loadTestsFromTestCase(HTMLBugTestCase)
    
    alltests = PyLPBugsTestSuite((HTMLBugTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
