import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored
from launchpadbugs.lpconstants import HTTPCONNECTION
from launchpadbugs.html_blueprintlist import BlueprintList, BlueprintPage, BPInfo
from launchpadbugs.http_connection import HTTPConnection

con = None

class HTMLBlueprintListTestCase(PyLPBugsTestCase):
    
    def test_001_setup_HTTPConnection(self):
        """ prepare the HTTPConnection object """
        global con
        con = HTTPConnection()
            
    def test_002_personal_blueprints(self):
        """[STABLE/EDGE] test personal blueprints """
        url = "https://blueprints.launchpad.net/~james-w"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bpiter, next, batchsize, length = BlueprintPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                blueprint = bpiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(blueprint, BPInfo), "wrong type of 'blueprint' in mode '%s'" %k)
            
    def test_003_project_blueprint(self):
        """[STABLE/EDGE] test project blueprints """
        url = "https://blueprints.launchpad.net/ubuntu"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bpiter, next, batchsize, length = BlueprintPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                blueprint = bpiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(blueprint, BPInfo), "wrong type of 'blueprint' in mode '%s'" %k)
            
    def test_004_milestone_blueprints(self):
        """[STABLE/EDGE] test milestone blueprints """
        url = "https://blueprints.launchpad.net/ubuntu/+milestone/intrepid-alpha-2"
        for k, i in {"STABLE": HTTPCONNECTION.MODE.STABLE, "EDGE" : HTTPCONNECTION.MODE.EDGE}.iteritems():
            con.set_mode(i)
            bpiter, next, batchsize, length = BlueprintPage.find_parse_function(con, url, False)
            self.assert_(isinstance(batchsize, int), "wrong type of 'batchsize' in mode '%s'" %k)
            self.assert_(isinstance(length, int), "wrong type of 'length' in mode '%s'" %k)
            self.assert_(isinstance(next, str) or next is False, "wrong type of 'next' in mode '%s'" %k)
            try:
                blueprint = bpiter.next()
            except StopIteration:
                return
            self.assert_(isinstance(blueprint, BPInfo), "wrong type of 'blueprint' in mode '%s'" %k)
            
    def test_005_buglist(self):
        """ test BugList """
        url1 = "https://blueprints.launchpad.net/ubuntu/+milestone/intrepid-alpha-2"
        url2 = "https://blueprints.launchpad.net/~james-w"
        BL1 = BlueprintList(url1, con)
        BL2 = BlueprintList(url2, con)
        BL1 += BL2
        x = BL1.sort("-delivery")
        y = BL1.sort("assignee")
        

if __name__ == '__main__':
    import unittest
    
    HTMLBlueprintListTestSuite = unittest.TestLoader().loadTestsFromTestCase(HTMLBlueprintListTestCase)
    
    alltests = PyLPBugsTestSuite((HTMLBlueprintListTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
