import unittest
import glob
import sys
import os
import time
import ConfigParser
import cStringIO as StringIO
from subprocess import Popen, PIPE, STDOUT

sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))
from launchpadbugs.config import Config

def getstdoutstderr(cmdline,inp=None): # return stoud and stderr in a single string object
    p = Popen(cmdline,stdin=PIPE,stdout=PIPE,stderr=STDOUT)
    output = p.communicate(inp)[0]
    if p.returncode != 0:
        raise Exception, "Command %s return code %s"%(cmdline,p.returncode)
    return output

def mail(subject, email_address, text):
    email_address = " ".join(email_address)
    return getstdoutstderr(["mail", "-s", subject, email_address], text)


class MergeStream(object):
    """An object that redirects `write` calls to multiple streams.
    Use this to log to both `sys.stderr` and a file
    """

    def __init__(self, *streams):
        if not streams:
            raise TypeError('at least one stream must be given')
        self.streams = streams

    def write(self, data):
        for stream in self.streams:
            stream.write(data)
            
    def writeln(self, arg=None):
        if arg:
            self.write(arg)
        self.write('\n')

    def flush(self, *args):
        for stream in self.streams:
            stream.flush(*args)


class TestCaseIgnored(Exception):
    def __init__(self, msg=None):
        self.msg = msg or ""
        
    def __str__(self):
        msg = ""
        if self.msg:
            msg = "\nReason:\n    %s" %self.msg
        return "This testcase has been ignored, please don't consider\
 this as a failure or an error in the sense of an unittest.%s" %msg
 
class SkipSuiteError(KeyboardInterrupt):
    def __init__(self, msg=None, fail=False):
        self.fail = bool(fail)
        self.msg = msg or ""

class PyLPBugsTestSuite(unittest.TestSuite):

    IGNORE_PATTERN = []
        
    def run(self, result):
        current = None
        skip_suite = (False,False)
        for test in self._tests:
            if not (test.__class__ == self.__class__ or test.__class__ == current):
                current = test.__class__
                skip_suite = (False,False)
                try:
                    x = test._tests[0]
                except:
                    try:
                        x = self._tests[0]
                    except:
                        x = None
                try:
                    m = x.__doc__
                    if m:
                        m = "Running: '%s'" %m
                    else:
                        m = "Running %s" %x.__class__.__name__
                except:
                    m = "New Suite"
                l = (70 - len(m) -2) / 2
                result.stream.writeln("="*70)
                result.stream.writeln("%s %s %s" %("+"*l, m, "+"*l))
                result.stream.writeln("-"*70)
            if result.shouldStop:
                break
            
            try:
                path = test.id()
            except:
                path = ""
            for i in PyLPBugsTestSuite.IGNORE_PATTERN:
                try:
                    r = i.match(path)
                except AttributeError:
                    r = path.startswith(i)
                if r:
                    try:
                        raise TestCaseIgnored, "Matched IGNORE_PATTERN"
                    except TestCaseIgnored, e:
                        result.startTest(test)
                        result.addError(test, test._exc_info())
                        result.stopTest(test)
                    break
            else:
                if not skip_suite[0]:
                    try:
                        test.xstream = result.stream
                        test(result)
                    except SkipSuiteError, e:
                        result.stream.writeln("%s -> SKIPSUITE" %e.msg)
                        skip_suite = (True, e.fail)
                elif skip_suite[1]:
                    # auto fail
                    pass
                else:
                    # auto skip
                    try:
                        raise TestCaseIgnored, "Matched IGNORE_PATTERN"
                    except TestCaseIgnored, e:
                        result.startTest(test)
                        result.addError(test, test._exc_info())
                        result.stopTest(test)
        return result

class PyLPBugsTestCase(unittest.TestCase):

    def _exc_info(self):
        """ This is a hack to be compatible with python 2.4 """
        if not hasattr(unittest.TestCase, "_exc_info"):
            exctype, excvalue, tb = sys.exc_info()
            if sys.platform[:4] == 'java': ## tracebacks look different in Jython
                return (exctype, excvalue, tb)
            return (exctype, excvalue, tb)
        else:
            return unittest.TestCase._exc_info(self)
        
    def failIfRaises(self, excClass, callableObj, *args, **kwargs):
        try:
            callableObj(*args, **kwargs)
        except excClass, e:
            excName = repr(e).split("(", 1)[0]
            if hasattr(e,'__name__'):
                excName = e.__name__
            elif hasattr(e,"__class__"):
                try:
                    excName = e.__class__.__name__
                except:
                    pass
            raise self.failureException, "%s raised!\n%s" % (excName, e)
            
    def assert_skip(self, test, msg=None, fail=False):
        if not test:
            raise SkipSuiteError(msg=msg, fail=fail)
            
    def tearDown(self):
        try:
            self.xstream.write(self.description)
        except:
            pass
    
class _PyLPTextTestResult(unittest._TextTestResult):
    def __init__(self, stream, descriptions, verbosity):
        unittest._TextTestResult.__init__(self, stream, descriptions, verbosity)
        self.ignored = []
        
    def addError(self, test, err):
        if issubclass(err[0], TestCaseIgnored):
            self.ignored.append((test, err[1].msg))
            if self.showAll:
                self.stream.writeln("IGNORED")
            elif self.dots:
                self.stream.write('I')
        else:
            unittest._TextTestResult.addError(self, test, err)
            
    def printErrors(self):
        unittest._TextTestResult.printErrors(self)
        self.printIgnored()
        
    def printIgnored(self):
        for test, err in self.ignored:
            self.stream.writeln(self.separator1)
            self.stream.writeln("IGNORED: %s" % self.getDescription(test))
            self.stream.writeln(self.separator2)
            self.stream.writeln("%s" % err)
        
            
class PyLPTextTestRunner(unittest.TextTestRunner):
    
    def __init__(self, descriptions=1, verbosity=1,
                    header=False, emails=None, email_cmd=None):
        self.email = emails
        self.email_cmd = email_cmd
        stream = [sys.stderr]
        if not self.email is None:
            stream.append(StringIO.StringIO())
        self.stream = MergeStream(*stream)
        self.descriptions = descriptions
        self.verbosity = verbosity
        if header:
            self.print_header()
            
    def print_header(self):
        self.stream.writeln("="*70)
        self.stream.writeln("python-launchpad-bugs testsuite")
        self.stream.writeln("-"*70)
        
        now = time.gmtime()
        self.stream.writeln("Date: %s" %time.strftime("%d %b %Y %H:%M:%S %Z", now))
        
        from get_build_number import VERSIONS, get_build_id
        self.stream.writeln("Versions of launchpad:")
        for k, i in VERSIONS.iteritems():
            try:
                x = get_build_id(i)
            except:
                x = "unknown"
            self.stream.writeln("\t%s: %s" %(k, x))
            
        from launchpadbugs.utils import find_version_number
        self.stream.writeln("Version of py-lp-bugs: %s" %find_version_number(show_nick=True))
        self.stream.writeln("python version: %s" %sys.version.replace("\n",""))        
        
    def send_email(self):
        msg = "\n".join(map(lambda x: x.getvalue(), self.stream.streams[1:]))
        subject = "[py-lp-bugs] [test results] %s" %time.strftime("%d %b %Y %H:%M:%S %Z", time.gmtime())
        if self.email_cmd == "mail":
            try:
                mail(subject, self.email, msg)
                self.stream.writeln("Successfully send results to %s" %", ".join(self.email))
            except Exception, e:
                self.stream.writeln("Failed to send email. %s" %e)
        else:
            raise ValueError
        
    def _makeResult(self):
        return _PyLPTextTestResult(self.stream, self.descriptions, self.verbosity)

    def run(self, test):
        "Run the given test case or test suite."
        result = self._makeResult()
        startTime = time.time()
        test(result)
        stopTime = time.time()
        timeTaken = stopTime - startTime
        result.printErrors()
        self.stream.writeln(result.separator2)
        run = result.testsRun
        self.stream.writeln("Ran %d test%s in %.3fs" %
                            (run, run != 1 and "s" or "", timeTaken))
        self.stream.writeln()
        if not result.wasSuccessful():
            self.stream.write("FAILED (")
            failed, errored = map(len, (result.failures, result.errors))
            if failed:
                self.stream.write("failures=%d" % failed)
            if errored:
                if failed: self.stream.write(", ")
                self.stream.write("errors=%d" % errored)
            self.stream.writeln(")")
        if result.ignored:
                self.stream.writeln("IGNORED %s" %len(result.ignored))
        if result.wasSuccessful() or result.ignored:
            self.stream.writeln("OK")
        if self.email:
            self.send_email()
        return result

class ConfigTest(Config):
    Config.MAPPING["test_examples"] = {"cookiefile": (lambda x: os.path.expanduser(x),),
                               "tests": (lambda x: x.split(), lambda x: " ".join(x)),
                               "ignore": (lambda x: x.split(), lambda x: " ".join(x))}
        
def list_testcases(locations=list()):
    tests = {}
    for i in locations:
        if i not in sys.path:
            sys.path.insert(0, i)
        for f in glob.glob("%s/testcase_*.py" %i):
            temp_cases = unittest.TestLoader()
            L = {}
            name, ext = os.path.splitext(f)
            name = os.path.split(name)[-1]
            __import__(name)
            mod = sys.modules[name]
            all = temp_cases.loadTestsFromModule(mod)
            for suite in all:
                for tc in suite:
                    if isinstance(tc, PyLPBugsTestCase):
                        key = tc.__class__.__name__
                        L.setdefault(key ,[]).append(tc.id().split(".")[-1])
                    
            tests[name] = L
    return tests

def loadfrom_names(names=list(), ignore_pattern=list()):
    suite = unittest.TestLoader()
    suite.suiteClass = PyLPBugsTestSuite
    PyLPBugsTestSuite.IGNORE_PATTERN = ignore_pattern
    return suite.loadTestsFromNames(names)    
    
def run_test(suite, emails=None, header=False, email_cmd=None):
    PyLPTextTestRunner(emails=emails, header=header,
            verbosity=2, email_cmd=email_cmd).run(suite)    
