import libxml2
import urllib
import re
        
# deactivate error messages from the validation [libxml2.htmlParseDoc]
def noerr(ctx, str):
    pass

libxml2.registerErrorHandler(noerr, None)

class UnknownBuildID(Exception):
    pass

VERSIONS = {"STABLE": "https://bugs.launchpad.net/",
            "EDGE": "https://bugs.edge.launchpad.net/",
            "STAGING": "https://bugs.staging.launchpad.net/"}
            
re_build_stable = re.compile(r"<!-- Launchpad.*\(r(\d+)\) -->")
re_build_edge = re.compile(r"\(r(\d+)\)")   
            
def get_build_id(url):
    try:
        content = urllib.urlopen(url).read()
        ctx = libxml2.htmlParseDoc(content, "UTF-8")
    except:
        raise UnknownBuildID
    try:
        #EDGE
        x = ctx.xpathEval('//span[@id="lp-version"]')
        build = int(re_build_edge.search(x[0].content).group(1))
    except:
        try:
            # STABLE: version number is no longer shown on the page itself
            # but as a comment in the source
            build = int(re_build_stable.search(content).group(1))
        except:
            raise UnknownBuildID
    return build
    
    
if __name__ == '__main__':
    for k, i in VERSIONS.iteritems():
        print k, get_build_id(i)
