import sys
from distutils.core import setup, Extension

# patch distutils if it can't cope with the "classifiers" and
# "download_url" keywords
if sys.version < '2.2.3':
    from distutils.dist import DistributionMetadata
    DistributionMetadata.classifiers = None
    DistributionMetadata.download_url = None

if sys.version.find('MSC')==-1:
    gmpy_ext = Extension('gmpy', sources=['src/gmpy.c'],
        # library_dirs=['/usr/local/lib'],
        libraries=['gmp'])
else:
    gmpy_ext = Extension('gmpy', sources=['src/gmpy.c'],
        include_dirs=['./src'],
        libraries=['gmp'])

setup (name = "gmpy",
       version = "1.01",
       maintainer = "Alex Martelli",
       maintainer_email = "aleaxit@gmail.com",
       url = "http://gmpy.sourceforge.net/",
       description = "GMP-4 to Python-2.{2,3,4} interface",
       download_url = "http://http://prdownloads.sourceforge.net/gmpy/gmpy-sources-101.zip?download",

       classifiers = [
         'Development Status :: 4 - Beta',
         'Intended Audience :: Developers',
         'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)',
         'Natural Language :: English',
         'Operating System :: MacOS :: MacOS X',
         'Operating System :: Microsoft :: Windows',
         'Operating System :: POSIX',
         'Programming Language :: C',
         'Programming Language :: Python',
         'Topic :: Scientific/Engineering :: Mathematics',
         'Topic :: Software Development :: Libraries :: Python Modules',
       ],
       
       ext_modules = [ gmpy_ext ]
)
