#!/usr/bin/env python

__all__ = ['run_main','compile','f2py_testing']

import os
import tempfile
import sys
import commands

import f2py2e
run_main = f2py2e.run_main
main = f2py2e.main
import f2py_testing

def compile(source,
            modulename = 'untitled',
            extra_args = '',
            verbose = 1,
            source_fn = None
            ):
    if source_fn is None:
        fname = os.path.join(tempfile.mktemp()+'.f')
    else:
        fname = source_fn
    f = open(fname,'w')
    f.write(source)
    f.close()

    args = ' -c -m %s %s %s'%(modulename,fname,extra_args)
    c = '%s -c "import f2py2e;f2py2e.main()" %s' %(sys.executable,args)
    if verbose or os.name!='posix':
        s = os.system(c)
    else:
        s,o=commands.getstatusoutput(c)
        if s:
            print>>sys.stderr,o
    if source_fn is None:
        try: os.remove(fname)
        except OSError: pass
    return s
