#!/usr/bin/env python
# -*- coding: utf-8 -*-
# #START_LICENSE###########################################################
#
#
# This file is part of the Environment for Tree Exploration program
# (ETE).  http://etetoolkit.org
#
# ETE is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ETE is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ETE.  If not, see <http://www.gnu.org/licenses/>.
#
#
#                     ABOUT THE ETE PACKAGE
#                     =====================
#
# ETE is distributed under the GPL copyleft license (2008-2015).
#
# If you make use of ETE in published work, please cite:
#
# Jaime Huerta-Cepas, Joaquin Dopazo and Toni Gabaldon.
# ETE: a python Environment for Tree Exploration. Jaime BMC
# Bioinformatics 2010,:24doi:10.1186/1471-2105-11-24
#
# Note that extra references to the specific methods implemented in
# the toolkit may be available in the documentation.
#
# More info at http://etetoolkit.org. Contact: huerta@embl.de
#
#
# #END_LICENSE#############################################################
from __future__ import absolute_import
from __future__ import print_function

#
# Generated Mon Jun 27 10:13:44 2011 by generateDS.py version 2.5b.
#

import sys
import getopt
import re as re_
import six
from six.moves import range

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = list(range(3))
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
STRING_CLEANUP_PAT = re_.compile(r"[\n\r\s]+")

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, six.string_types) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, six.string_types) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    # First try with no namespace.
    value = attrs.get(attr_name)
    if value is None:
        # Now try the other possible namespaces.
        namespaces = six.itervalues(node.nsmap)
        for namespace in namespaces:
            value = attrs.get('{%s}%s' % (namespace, attr_name, ))
            if value is not None:
                break
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class Phyloxml(GeneratedsSuper):
    """'phyloxml' is the name of the root element. Phyloxml contains an
    arbitrary number of 'phylogeny' elements (each representing one
    phylogeny) possibly followed by elements from other namespaces."""
    subclass = None
    superclass = None
    def __init__(self, phylogeny=None, valueOf_=None):
        if phylogeny is None:
            self.phylogeny = []
        else:
            self.phylogeny = phylogeny
    def factory(*args_, **kwargs_):
        if Phyloxml.subclass:
            return Phyloxml.subclass(*args_, **kwargs_)
        else:
            return Phyloxml(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phylogeny(self): return self.phylogeny
    def set_phylogeny(self, phylogeny): self.phylogeny = phylogeny
    def add_phylogeny(self, value): self.phylogeny.append(value)
    def insert_phylogeny(self, index, value): self.phylogeny[index] = value
    def export(self, outfile, level, namespace_='phy:', name_='Phyloxml', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Phyloxml')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Phyloxml'):
        pass
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Phyloxml', fromsubclass_=False):
        for phylogeny_ in self.phylogeny:
            phylogeny_.export(outfile, level, namespace_, name_='phylogeny')
    def hasContent_(self):
        if (
            self.phylogeny
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Phyloxml'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('phylogeny=[\n')
        level += 1
        for phylogeny_ in self.phylogeny:
            showIndent(outfile, level)
            outfile.write('model_.Phylogeny(\n')
            phylogeny_.exportLiteral(outfile, level, name_='Phylogeny')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'phylogeny':
            obj_ = Phylogeny.factory()
            obj_.build(child_)
            self.phylogeny.append(obj_)
# end class Phyloxml


class Phylogeny(GeneratedsSuper):
    """Element Phylogeny is used to represent a phylogeny. The required
    attribute 'rooted' is used to indicate whether the phylogeny is
    rooted or not. The attribute 'rerootable' can be used to
    indicate that the phylogeny is not allowed to be rooted
    differently (i.e. because it is associated with root dependent
    data, such as gene duplications). The attribute 'type' can be
    used to indicate the type of phylogeny (i.e. 'gene tree'). It is
    recommended to use the attribute 'branch_length_unit' if the
    phylogeny has branch lengths. Element clade is used in a
    recursive manner to describe the topology of a phylogenetic
    tree."""
    subclass = None
    superclass = None
    def __init__(self, rerootable=None, branch_length_unit=None, type_=None, rooted=None, name=None, id=None, description=None, date=None, confidence=None, clade=None, clade_relation=None, sequence_relation=None, property=None, valueOf_=None):
        self.rerootable = _cast(bool, rerootable)
        self.branch_length_unit = _cast(None, branch_length_unit)
        self.type_ = _cast(None, type_)
        self.rooted = _cast(bool, rooted)
        self.name = name
        self.id = id
        self.description = description
        self.date = date
        if confidence is None:
            self.confidence = []
        else:
            self.confidence = confidence
        self.clade = clade
        if clade_relation is None:
            self.clade_relation = []
        else:
            self.clade_relation = clade_relation
        if sequence_relation is None:
            self.sequence_relation = []
        else:
            self.sequence_relation = sequence_relation
        if property is None:
            self.property = []
        else:
            self.property = property
    def factory(*args_, **kwargs_):
        if Phylogeny.subclass:
            return Phylogeny.subclass(*args_, **kwargs_)
        else:
            return Phylogeny(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def add_confidence(self, value): self.confidence.append(value)
    def insert_confidence(self, index, value): self.confidence[index] = value
    def get_clade(self): return self.clade
    def set_clade(self, clade): self.clade = clade
    def get_clade_relation(self): return self.clade_relation
    def set_clade_relation(self, clade_relation): self.clade_relation = clade_relation
    def add_clade_relation(self, value): self.clade_relation.append(value)
    def insert_clade_relation(self, index, value): self.clade_relation[index] = value
    def get_sequence_relation(self): return self.sequence_relation
    def set_sequence_relation(self, sequence_relation): self.sequence_relation = sequence_relation
    def add_sequence_relation(self, value): self.sequence_relation.append(value)
    def insert_sequence_relation(self, index, value): self.sequence_relation[index] = value
    def get_property(self): return self.property
    def set_property(self, property): self.property = property
    def add_property(self, value): self.property.append(value)
    def insert_property(self, index, value): self.property[index] = value
    def get_rerootable(self): return self.rerootable
    def set_rerootable(self, rerootable): self.rerootable = rerootable
    def get_branch_length_unit(self): return self.branch_length_unit
    def set_branch_length_unit(self, branch_length_unit): self.branch_length_unit = branch_length_unit
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_rooted(self): return self.rooted
    def set_rooted(self, rooted): self.rooted = rooted
    def export(self, outfile, level, namespace_='phy:', name_='Phylogeny', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Phylogeny')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Phylogeny'):
        if self.rerootable is not None and 'rerootable' not in already_processed:
            already_processed.append('rerootable')
            outfile.write(' rerootable="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.rerootable)), input_name='rerootable'))
        if self.branch_length_unit is not None and 'branch_length_unit' not in already_processed:
            already_processed.append('branch_length_unit')
            outfile.write(' branch_length_unit=%s' % (self.gds_format_string(quote_attrib(self.branch_length_unit).encode(ExternalEncoding), input_name='branch_length_unit'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.rooted is not None and 'rooted' not in already_processed:
            already_processed.append('rooted')
            outfile.write(' rooted="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.rooted)), input_name='rooted'))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Phylogeny', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.id:
            self.id.export(outfile, level, namespace_, name_='id')
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('<%sdate>%s</%sdate>\n' % (namespace_, self.gds_format_string(quote_xml(self.date).encode(ExternalEncoding), input_name='date'), namespace_))
        for confidence_ in self.confidence:
            confidence_.export(outfile, level, namespace_, name_='confidence')
        if self.clade:
            self.clade.export(outfile, level, namespace_, name_='clade')
        for clade_relation_ in self.clade_relation:
            clade_relation_.export(outfile, level, namespace_, name_='clade_relation')
        for sequence_relation_ in self.sequence_relation:
            sequence_relation_.export(outfile, level, namespace_, name_='sequence_relation')
        for property_ in self.property:
            property_.export(outfile, level, namespace_, name_='property')
    def hasContent_(self):
        if (
            self.name is not None or
            self.id is not None or
            self.description is not None or
            self.date is not None or
            self.confidence or
            self.clade is not None or
            self.clade_relation or
            self.sequence_relation or
            self.property
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Phylogeny'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rerootable is not None and 'rerootable' not in already_processed:
            already_processed.append('rerootable')
            showIndent(outfile, level)
            outfile.write('rerootable = %s,\n' % (self.rerootable,))
        if self.branch_length_unit is not None and 'branch_length_unit' not in already_processed:
            already_processed.append('branch_length_unit')
            showIndent(outfile, level)
            outfile.write('branch_length_unit = "%s",\n' % (self.branch_length_unit,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.rooted is not None and 'rooted' not in already_processed:
            already_processed.append('rooted')
            showIndent(outfile, level)
            outfile.write('rooted = %s,\n' % (self.rooted,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=model_.Id(\n')
            self.id.exportLiteral(outfile, level, name_='id')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('date=%s,\n' % quote_python(self.date).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('confidence=[\n')
        level += 1
        for confidence_ in self.confidence:
            showIndent(outfile, level)
            outfile.write('model_.Confidence(\n')
            confidence_.exportLiteral(outfile, level, name_='Confidence')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.clade is not None:
            showIndent(outfile, level)
            outfile.write('clade=model_.Clade(\n')
            self.clade.exportLiteral(outfile, level, name_='clade')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('clade_relation=[\n')
        level += 1
        for clade_relation_ in self.clade_relation:
            showIndent(outfile, level)
            outfile.write('model_.CladeRelation(\n')
            clade_relation_.exportLiteral(outfile, level, name_='CladeRelation')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('sequence_relation=[\n')
        level += 1
        for sequence_relation_ in self.sequence_relation:
            showIndent(outfile, level)
            outfile.write('model_.SequenceRelation(\n')
            sequence_relation_.exportLiteral(outfile, level, name_='SequenceRelation')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('property=[\n')
        level += 1
        for property_ in self.property:
            showIndent(outfile, level)
            outfile.write('model_.Property(\n')
            property_.exportLiteral(outfile, level, name_='Property')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rerootable', node)
        if value is not None and 'rerootable' not in already_processed:
            already_processed.append('rerootable')
            if value in ('true', '1'):
                self.rerootable = True
            elif value in ('false', '0'):
                self.rerootable = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('branch_length_unit', node)
        if value is not None and 'branch_length_unit' not in already_processed:
            already_processed.append('branch_length_unit')
            self.branch_length_unit = value
            self.branch_length_unit = ' '.join(self.branch_length_unit.split())
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('rooted', node)
        if value is not None and 'rooted' not in already_processed:
            already_processed.append('rooted')
            if value in ('true', '1'):
                self.rooted = True
            elif value in ('false', '0'):
                self.rooted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = re_.sub(STRING_CLEANUP_PAT, " ", name_).strip()
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'id':
            obj_ = Id.factory()
            obj_.build(child_)
            self.set_id(obj_)
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = re_.sub(STRING_CLEANUP_PAT, " ", description_).strip()
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'date':
            date_ = child_.text
            date_ = self.gds_validate_string(date_, node, 'date')
            self.date = date_
        elif nodeName_ == 'confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.confidence.append(obj_)
        elif nodeName_ == 'clade':
            obj_ = Clade.factory()
            obj_.build(child_)
            self.set_clade(obj_)
        elif nodeName_ == 'clade_relation':
            obj_ = CladeRelation.factory()
            obj_.build(child_)
            self.clade_relation.append(obj_)
        elif nodeName_ == 'sequence_relation':
            obj_ = SequenceRelation.factory()
            obj_.build(child_)
            self.sequence_relation.append(obj_)
        elif nodeName_ == 'property':
            obj_ = Property.factory()
            obj_.build(child_)
            self.property.append(obj_)
# end class Phylogeny


class Clade(GeneratedsSuper):
    """Element Clade is used in a recursive manner to describe the topology
    of a phylogenetic tree. The parent branch length of a clade can
    be described either with the 'branch_length' element or the
    'branch_length' attribute (it is not recommended to use both at
    the same time, though). Usage of the 'branch_length' attribute
    allows for a less verbose description. Element 'confidence' is
    used to indicate the support for a clade/parent branch. Element
    'events' is used to describe such events as gene-duplications at
    the root node/parent branch of a clade. Element 'width' is the
    branch width for this clade (including parent branch). Both
    'color' and 'width' elements apply for the whole clade unless
    overwritten in-sub clades. Attribute 'id_source' is used to link
    other elements to a clade (on the xml-level)."""
    subclass = None
    superclass = None
    def __init__(self, id_source=None, branch_length_attr=None, name=None, branch_length=None, confidence=None, width=None, color=None, node_id=None, taxonomy=None, sequence=None, events=None, binary_characters=None, distribution=None, date=None, reference=None, property=None, clade=None, valueOf_=None):
        self.id_source = _cast(None, id_source)
        self.branch_length_attr = _cast(None, branch_length_attr)
        self.name = name
        self.branch_length = branch_length
        if confidence is None:
            self.confidence = []
        else:
            self.confidence = confidence
        self.width = width
        self.color = color
        self.node_id = node_id
        if taxonomy is None:
            self.taxonomy = []
        else:
            self.taxonomy = taxonomy
        if sequence is None:
            self.sequence = []
        else:
            self.sequence = sequence
        self.events = events
        self.binary_characters = binary_characters
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
        self.date = date
        if reference is None:
            self.reference = []
        else:
            self.reference = reference
        if property is None:
            self.property = []
        else:
            self.property = property
        if clade is None:
            self.clade = []
        else:
            self.clade = clade
    def factory(*args_, **kwargs_):
        if Clade.subclass:
            return Clade.subclass(*args_, **kwargs_)
        else:
            return Clade(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_branch_length(self): return self.branch_length
    def set_branch_length(self, branch_length): self.branch_length = branch_length
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def add_confidence(self, value): self.confidence.append(value)
    def insert_confidence(self, index, value): self.confidence[index] = value
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    def get_color(self): return self.color
    def set_color(self, color): self.color = color
    def get_node_id(self): return self.node_id
    def set_node_id(self, node_id): self.node_id = node_id
    def get_taxonomy(self): return self.taxonomy
    def set_taxonomy(self, taxonomy): self.taxonomy = taxonomy
    def add_taxonomy(self, value): self.taxonomy.append(value)
    def insert_taxonomy(self, index, value): self.taxonomy[index] = value
    def get_sequence(self): return self.sequence
    def set_sequence(self, sequence): self.sequence = sequence
    def add_sequence(self, value): self.sequence.append(value)
    def insert_sequence(self, index, value): self.sequence[index] = value
    def get_events(self): return self.events
    def set_events(self, events): self.events = events
    def get_binary_characters(self): return self.binary_characters
    def set_binary_characters(self, binary_characters): self.binary_characters = binary_characters
    def get_distribution(self): return self.distribution
    def set_distribution(self, distribution): self.distribution = distribution
    def add_distribution(self, value): self.distribution.append(value)
    def insert_distribution(self, index, value): self.distribution[index] = value
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_reference(self): return self.reference
    def set_reference(self, reference): self.reference = reference
    def add_reference(self, value): self.reference.append(value)
    def insert_reference(self, index, value): self.reference[index] = value
    def get_property(self): return self.property
    def set_property(self, property): self.property = property
    def add_property(self, value): self.property.append(value)
    def insert_property(self, index, value): self.property[index] = value
    def get_clade(self): return self.clade
    def set_clade(self, clade): self.clade = clade
    def add_clade(self, value): self.clade.append(value)
    def insert_clade(self, index, value): self.clade[index] = value
    def get_id_source(self): return self.id_source
    def set_id_source(self, id_source): self.id_source = id_source
    def get_branch_length_attr(self): return self.branch_length_attr
    def set_branch_length_attr(self, branch_length_attr): self.branch_length_attr = branch_length_attr
    def export(self, outfile, level, namespace_='phy:', name_='Clade', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Clade')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Clade'):
        if self.id_source is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            outfile.write(' id_source=%s' % (quote_attrib(self.id_source), ))
        if self.branch_length_attr is not None and 'branch_length_attr' not in already_processed:
            already_processed.append('branch_length_attr')
            outfile.write(' branch_length_attr=%s' % (self.gds_format_string(quote_attrib(self.branch_length_attr).encode(ExternalEncoding), input_name='branch_length_attr'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Clade', fromsubclass_=False):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.branch_length is not None:
            showIndent(outfile, level)
            outfile.write('<%sbranch_length>%s</%sbranch_length>\n' % (namespace_, self.gds_format_double(self.branch_length, input_name='branch_length'), namespace_))
        for confidence_ in self.confidence:
            confidence_.export(outfile, level, namespace_, name_='confidence')
        if self.width is not None:
            showIndent(outfile, level)
            outfile.write('<%swidth>%s</%swidth>\n' % (namespace_, self.gds_format_double(self.width, input_name='width'), namespace_))
        if self.color:
            self.color.export(outfile, level, namespace_, name_='color')
        if self.node_id:
            self.node_id.export(outfile, level, namespace_, name_='node_id')
        for taxonomy_ in self.taxonomy:
            taxonomy_.export(outfile, level, namespace_, name_='taxonomy')
        for sequence_ in self.sequence:
            sequence_.export(outfile, level, namespace_, name_='sequence')
        if self.events:
            self.events.export(outfile, level, namespace_, name_='events')
        if self.binary_characters:
            self.binary_characters.export(outfile, level, namespace_, name_='binary_characters')
        for distribution_ in self.distribution:
            distribution_.export(outfile, level, namespace_, name_='distribution')
        if self.date:
            self.date.export(outfile, level, namespace_, name_='date')
        for reference_ in self.reference:
            reference_.export(outfile, level, namespace_, name_='reference')
        for property_ in self.property:
            property_.export(outfile, level, namespace_, name_='property')
        for clade_ in self.clade:
            clade_.export(outfile, level, namespace_, name_='clade')
    def hasContent_(self):
        if (
            self.name is not None or
            self.branch_length is not None or
            self.confidence or
            self.width is not None or
            self.color is not None or
            self.node_id is not None or
            self.taxonomy or
            self.sequence or
            self.events is not None or
            self.binary_characters is not None or
            self.distribution or
            self.date is not None or
            self.reference or
            self.property or
            self.clade
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Clade'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id_source is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            showIndent(outfile, level)
            outfile.write('id_source = %s,\n' % (self.id_source,))
        if self.branch_length_attr is not None and 'branch_length_attr' not in already_processed:
            already_processed.append('branch_length_attr')
            showIndent(outfile, level)
            outfile.write('branch_length_attr = "%s",\n' % (self.branch_length_attr,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.branch_length is not None:
            showIndent(outfile, level)
            outfile.write('branch_length=%e,\n' % self.branch_length)
        showIndent(outfile, level)
        outfile.write('confidence=[\n')
        level += 1
        for confidence_ in self.confidence:
            showIndent(outfile, level)
            outfile.write('model_.Confidence(\n')
            confidence_.exportLiteral(outfile, level, name_='Confidence')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.width is not None:
            showIndent(outfile, level)
            outfile.write('width=%e,\n' % self.width)
        if self.color is not None:
            showIndent(outfile, level)
            outfile.write('color=model_.BranchColor(\n')
            self.color.exportLiteral(outfile, level, name_='color')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.node_id is not None:
            showIndent(outfile, level)
            outfile.write('node_id=model_.Id(\n')
            self.node_id.exportLiteral(outfile, level, name_='node_id')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('taxonomy=[\n')
        level += 1
        for taxonomy_ in self.taxonomy:
            showIndent(outfile, level)
            outfile.write('model_.Taxonomy(\n')
            taxonomy_.exportLiteral(outfile, level, name_='Taxonomy')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('sequence=[\n')
        level += 1
        for sequence_ in self.sequence:
            showIndent(outfile, level)
            outfile.write('model_.Sequence(\n')
            sequence_.exportLiteral(outfile, level, name_='Sequence')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.events is not None:
            showIndent(outfile, level)
            outfile.write('events=model_.Events(\n')
            self.events.exportLiteral(outfile, level, name_='events')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.binary_characters is not None:
            showIndent(outfile, level)
            outfile.write('binary_characters=model_.BinaryCharacters(\n')
            self.binary_characters.exportLiteral(outfile, level, name_='binary_characters')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('distribution=[\n')
        level += 1
        for distribution_ in self.distribution:
            showIndent(outfile, level)
            outfile.write('model_.Distribution(\n')
            distribution_.exportLiteral(outfile, level, name_='Distribution')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('date=model_.Date(\n')
            self.date.exportLiteral(outfile, level, name_='date')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('reference=[\n')
        level += 1
        for reference_ in self.reference:
            showIndent(outfile, level)
            outfile.write('model_.Reference(\n')
            reference_.exportLiteral(outfile, level, name_='Reference')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('property=[\n')
        level += 1
        for property_ in self.property:
            showIndent(outfile, level)
            outfile.write('model_.Property(\n')
            property_.exportLiteral(outfile, level, name_='Property')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('clade=[\n')
        level += 1
        for clade_ in self.clade:
            showIndent(outfile, level)
            outfile.write('model_.Clade(\n')
            clade_.exportLiteral(outfile, level, name_='Clade')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id_source', node)
        if value is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            self.id_source = value
        value = find_attr_value_('branch_length_attr', node)
        if value is not None and 'branch_length_attr' not in already_processed:
            already_processed.append('branch_length_attr')
            self.branch_length_attr = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = re_.sub(STRING_CLEANUP_PAT, " ", name_).strip()
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'branch_length':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'branch_length')
            self.branch_length = fval_
        elif nodeName_ == 'confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.confidence.append(obj_)
        elif nodeName_ == 'width':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'width')
            self.width = fval_
        elif nodeName_ == 'color':
            obj_ = BranchColor.factory()
            obj_.build(child_)
            self.set_color(obj_)
        elif nodeName_ == 'node_id':
            obj_ = Id.factory()
            obj_.build(child_)
            self.set_node_id(obj_)
        elif nodeName_ == 'taxonomy':
            obj_ = Taxonomy.factory()
            obj_.build(child_)
            self.taxonomy.append(obj_)
        elif nodeName_ == 'sequence':
            obj_ = Sequence.factory()
            obj_.build(child_)
            self.sequence.append(obj_)
        elif nodeName_ == 'events':
            obj_ = Events.factory()
            obj_.build(child_)
            self.set_events(obj_)
        elif nodeName_ == 'binary_characters':
            obj_ = BinaryCharacters.factory()
            obj_.build(child_)
            self.set_binary_characters(obj_)
        elif nodeName_ == 'distribution':
            obj_ = Distribution.factory()
            obj_.build(child_)
            self.distribution.append(obj_)
        elif nodeName_ == 'date':
            obj_ = Date.factory()
            obj_.build(child_)
            self.set_date(obj_)
        elif nodeName_ == 'reference':
            obj_ = Reference.factory()
            obj_.build(child_)
            self.reference.append(obj_)
        elif nodeName_ == 'property':
            obj_ = Property.factory()
            obj_.build(child_)
            self.property.append(obj_)
        elif nodeName_ == 'clade':
            obj_ = Clade.factory()
            obj_.build(child_)
            self.clade.append(obj_)
# end class Clade


class Taxonomy(GeneratedsSuper):
    """Element Taxonomy is used to describe taxonomic information for a
    clade. Element 'code' is intended to store UniProt/Swiss-Prot
    style organism codes (e.g. 'APLCA' for the California sea hare
    'Aplysia californica') or other styles of mnemonics (e.g.
    'Aca'). Element 'authority' is used to keep the authority, such
    as 'J. G. Cooper, 1863', associated with the 'scientific_name'.
    Element 'id' is used for a unique identifier of a taxon (for
    example '6500' with 'ncbi_taxonomy' as 'provider' for the
    California sea hare). Attribute 'id_source' is used to link
    other elements to a taxonomy (on the xml-level)."""
    subclass = None
    superclass = None
    def __init__(self, id_source=None, id=None, code=None, scientific_name=None, authority=None, common_name=None, synonym=None, rank=None, uri=None, valueOf_=None):
        self.id_source = _cast(None, id_source)
        self.id = id
        self.code = code
        self.scientific_name = scientific_name
        self.authority = authority
        if common_name is None:
            self.common_name = []
        else:
            self.common_name = common_name
        if synonym is None:
            self.synonym = []
        else:
            self.synonym = synonym
        self.rank = rank
        self.uri = uri
    def factory(*args_, **kwargs_):
        if Taxonomy.subclass:
            return Taxonomy.subclass(*args_, **kwargs_)
        else:
            return Taxonomy(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def validate_TaxonomyCode(self, value):
        # Validate type TaxonomyCode, a restriction on xs:token.
        pass
    def get_scientific_name(self): return self.scientific_name
    def set_scientific_name(self, scientific_name): self.scientific_name = scientific_name
    def get_authority(self): return self.authority
    def set_authority(self, authority): self.authority = authority
    def get_common_name(self): return self.common_name
    def set_common_name(self, common_name): self.common_name = common_name
    def add_common_name(self, value): self.common_name.append(value)
    def insert_common_name(self, index, value): self.common_name[index] = value
    def get_synonym(self): return self.synonym
    def set_synonym(self, synonym): self.synonym = synonym
    def add_synonym(self, value): self.synonym.append(value)
    def insert_synonym(self, index, value): self.synonym[index] = value
    def get_rank(self): return self.rank
    def set_rank(self, rank): self.rank = rank
    def validate_Rank(self, value):
        # Validate type Rank, a restriction on xs:token.
        pass
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_id_source(self): return self.id_source
    def set_id_source(self, id_source): self.id_source = id_source
    def export(self, outfile, level, namespace_='phy:', name_='Taxonomy', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Taxonomy')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Taxonomy'):
        if self.id_source is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            outfile.write(' id_source=%s' % (quote_attrib(self.id_source), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Taxonomy', fromsubclass_=False):
        if self.id:
            self.id.export(outfile, level, namespace_, name_='id')
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('<%scode>%s</%scode>\n' % (namespace_, self.gds_format_string(quote_xml(self.code).encode(ExternalEncoding), input_name='code'), namespace_))
        if self.scientific_name is not None:
            showIndent(outfile, level)
            outfile.write('<%sscientific_name>%s</%sscientific_name>\n' % (namespace_, self.gds_format_string(quote_xml(self.scientific_name).encode(ExternalEncoding), input_name='scientific_name'), namespace_))
        if self.authority is not None:
            showIndent(outfile, level)
            outfile.write('<%sauthority>%s</%sauthority>\n' % (namespace_, self.gds_format_string(quote_xml(self.authority).encode(ExternalEncoding), input_name='authority'), namespace_))
        for common_name_ in self.common_name:
            showIndent(outfile, level)
            outfile.write('<%scommon_name>%s</%scommon_name>\n' % (namespace_, self.gds_format_string(quote_xml(common_name_).encode(ExternalEncoding), input_name='common_name'), namespace_))
        for synonym_ in self.synonym:
            showIndent(outfile, level)
            outfile.write('<%ssynonym>%s</%ssynonym>\n' % (namespace_, self.gds_format_string(quote_xml(synonym_).encode(ExternalEncoding), input_name='synonym'), namespace_))
        if self.rank is not None:
            showIndent(outfile, level)
            outfile.write('<%srank>%s</%srank>\n' % (namespace_, self.gds_format_string(quote_xml(self.rank).encode(ExternalEncoding), input_name='rank'), namespace_))
        if self.uri:
            self.uri.export(outfile, level, namespace_, name_='uri')
    def hasContent_(self):
        if (
            self.id is not None or
            self.code is not None or
            self.scientific_name is not None or
            self.authority is not None or
            self.common_name or
            self.synonym or
            self.rank is not None or
            self.uri is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Taxonomy'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id_source is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            showIndent(outfile, level)
            outfile.write('id_source = %s,\n' % (self.id_source,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id=model_.Id(\n')
            self.id.exportLiteral(outfile, level, name_='id')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.code is not None:
            showIndent(outfile, level)
            outfile.write('code=%s,\n' % quote_python(self.code).encode(ExternalEncoding))
        if self.scientific_name is not None:
            showIndent(outfile, level)
            outfile.write('scientific_name=%s,\n' % quote_python(self.scientific_name).encode(ExternalEncoding))
        if self.authority is not None:
            showIndent(outfile, level)
            outfile.write('authority=%s,\n' % quote_python(self.authority).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('common_name=[\n')
        level += 1
        for common_name_ in self.common_name:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(common_name_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('synonym=[\n')
        level += 1
        for synonym_ in self.synonym:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(synonym_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.rank is not None:
            showIndent(outfile, level)
            outfile.write('rank=%s,\n' % quote_python(self.rank).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=model_.Uri(\n')
            self.uri.exportLiteral(outfile, level, name_='uri')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id_source', node)
        if value is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            self.id_source = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            obj_ = Id.factory()
            obj_.build(child_)
            self.set_id(obj_)
        elif nodeName_ == 'code':
            code_ = child_.text
            code_ = re_.sub(STRING_CLEANUP_PAT, " ", code_).strip()
            code_ = self.gds_validate_string(code_, node, 'code')
            self.code = code_
            self.validate_TaxonomyCode(self.code)    # validate type TaxonomyCode
        elif nodeName_ == 'scientific_name':
            scientific_name_ = child_.text
            scientific_name_ = re_.sub(STRING_CLEANUP_PAT, " ", scientific_name_).strip()
            scientific_name_ = self.gds_validate_string(scientific_name_, node, 'scientific_name')
            self.scientific_name = scientific_name_
        elif nodeName_ == 'authority':
            authority_ = child_.text
            authority_ = re_.sub(STRING_CLEANUP_PAT, " ", authority_).strip()
            authority_ = self.gds_validate_string(authority_, node, 'authority')
            self.authority = authority_
        elif nodeName_ == 'common_name':
            common_name_ = child_.text
            common_name_ = re_.sub(STRING_CLEANUP_PAT, " ", common_name_).strip()
            common_name_ = self.gds_validate_string(common_name_, node, 'common_name')
            self.common_name.append(common_name_)
        elif nodeName_ == 'synonym':
            synonym_ = child_.text
            synonym_ = re_.sub(STRING_CLEANUP_PAT, " ", synonym_).strip()
            synonym_ = self.gds_validate_string(synonym_, node, 'synonym')
            self.synonym.append(synonym_)
        elif nodeName_ == 'rank':
            rank_ = child_.text
            rank_ = re_.sub(STRING_CLEANUP_PAT, " ", rank_).strip()
            rank_ = self.gds_validate_string(rank_, node, 'rank')
            self.rank = rank_
            self.validate_Rank(self.rank)    # validate type Rank
        elif nodeName_ == 'uri':
            obj_ = Uri.factory()
            obj_.build(child_)
            self.set_uri(obj_)
# end class Taxonomy


class Sequence(GeneratedsSuper):
    """Element Sequence is used to represent a molecular sequence (Protein,
    DNA, RNA) associated with a node. 'symbol' is a short (maximal
    ten characters) symbol of the sequence (e.g. 'ACTM') whereas
    'name' is used for the full name (e.g. 'muscle Actin').
    'location' is used for the location of a sequence on a
    genome/chromosome. The actual sequence can be stored with the
    'mol_seq' element. Attribute 'type' is used to indicate the type
    of sequence ('dna', 'rna', or 'protein'). One intended use for
    'id_ref' is to link a sequence to a taxonomy (via the taxonomy's
    'id_source') in case of multiple sequences and taxonomies per
    node."""
    subclass = None
    superclass = None
    def __init__(self, id_source=None, id_ref=None, type_=None, symbol=None, accession=None, name=None, location=None, mol_seq=None, uri=None, annotation=None, domain_architecture=None, valueOf_=None):
        self.id_source = _cast(None, id_source)
        self.id_ref = _cast(None, id_ref)
        self.type_ = _cast(None, type_)
        self.symbol = symbol
        self.accession = accession
        self.name = name
        self.location = location
        self.mol_seq = mol_seq
        self.uri = uri
        if annotation is None:
            self.annotation = []
        else:
            self.annotation = annotation
        self.domain_architecture = domain_architecture
    def factory(*args_, **kwargs_):
        if Sequence.subclass:
            return Sequence.subclass(*args_, **kwargs_)
        else:
            return Sequence(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_SequenceSymbol(self, value):
        # Validate type SequenceSymbol, a restriction on xs:token.
        pass
    def get_accession(self): return self.accession
    def set_accession(self, accession): self.accession = accession
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_location(self): return self.location
    def set_location(self, location): self.location = location
    def get_mol_seq(self): return self.mol_seq
    def set_mol_seq(self, mol_seq): self.mol_seq = mol_seq
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_annotation(self): return self.annotation
    def set_annotation(self, annotation): self.annotation = annotation
    def add_annotation(self, value): self.annotation.append(value)
    def insert_annotation(self, index, value): self.annotation[index] = value
    def get_domain_architecture(self): return self.domain_architecture
    def set_domain_architecture(self, domain_architecture): self.domain_architecture = domain_architecture
    def get_id_source(self): return self.id_source
    def set_id_source(self, id_source): self.id_source = id_source
    def get_id_ref(self): return self.id_ref
    def set_id_ref(self, id_ref): self.id_ref = id_ref
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def export(self, outfile, level, namespace_='phy:', name_='Sequence', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Sequence')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Sequence'):
        if self.id_source is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            outfile.write(' id_source=%s' % (quote_attrib(self.id_source), ))
        if self.id_ref is not None and 'id_ref' not in already_processed:
            already_processed.append('id_ref')
            outfile.write(' id_ref=%s' % (quote_attrib(self.id_ref), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Sequence', fromsubclass_=False):
        if self.symbol is not None:
            showIndent(outfile, level)
            outfile.write('<%ssymbol>%s</%ssymbol>\n' % (namespace_, self.gds_format_string(quote_xml(self.symbol).encode(ExternalEncoding), input_name='symbol'), namespace_))
        if self.accession:
            self.accession.export(outfile, level, namespace_, name_='accession')
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('<%slocation>%s</%slocation>\n' % (namespace_, self.gds_format_string(quote_xml(self.location).encode(ExternalEncoding), input_name='location'), namespace_))
        if self.mol_seq:
            self.mol_seq.export(outfile, level, namespace_, name_='mol_seq')
        if self.uri:
            self.uri.export(outfile, level, namespace_, name_='uri')
        for annotation_ in self.annotation:
            annotation_.export(outfile, level, namespace_, name_='annotation')
        if self.domain_architecture:
            self.domain_architecture.export(outfile, level, namespace_, name_='domain_architecture')
    def hasContent_(self):
        if (
            self.symbol is not None or
            self.accession is not None or
            self.name is not None or
            self.location is not None or
            self.mol_seq is not None or
            self.uri is not None or
            self.annotation or
            self.domain_architecture is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Sequence'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id_source is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            showIndent(outfile, level)
            outfile.write('id_source = %s,\n' % (self.id_source,))
        if self.id_ref is not None and 'id_ref' not in already_processed:
            already_processed.append('id_ref')
            showIndent(outfile, level)
            outfile.write('id_ref = %s,\n' % (self.id_ref,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.symbol is not None:
            showIndent(outfile, level)
            outfile.write('symbol=%s,\n' % quote_python(self.symbol).encode(ExternalEncoding))
        if self.accession is not None:
            showIndent(outfile, level)
            outfile.write('accession=model_.Accession(\n')
            self.accession.exportLiteral(outfile, level, name_='accession')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('location=%s,\n' % quote_python(self.location).encode(ExternalEncoding))
        if self.mol_seq is not None:
            showIndent(outfile, level)
            outfile.write('mol_seq=model_.MolSeq(\n')
            self.mol_seq.exportLiteral(outfile, level, name_='mol_seq')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=model_.Uri(\n')
            self.uri.exportLiteral(outfile, level, name_='uri')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('annotation=[\n')
        level += 1
        for annotation_ in self.annotation:
            showIndent(outfile, level)
            outfile.write('model_.Annotation(\n')
            annotation_.exportLiteral(outfile, level, name_='Annotation')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.domain_architecture is not None:
            showIndent(outfile, level)
            outfile.write('domain_architecture=model_.DomainArchitecture(\n')
            self.domain_architecture.exportLiteral(outfile, level, name_='domain_architecture')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id_source', node)
        if value is not None and 'id_source' not in already_processed:
            already_processed.append('id_source')
            self.id_source = value
        value = find_attr_value_('id_ref', node)
        if value is not None and 'id_ref' not in already_processed:
            already_processed.append('id_ref')
            self.id_ref = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'symbol':
            symbol_ = child_.text
            symbol_ = re_.sub(STRING_CLEANUP_PAT, " ", symbol_).strip()
            symbol_ = self.gds_validate_string(symbol_, node, 'symbol')
            self.symbol = symbol_
            self.validate_SequenceSymbol(self.symbol)    # validate type SequenceSymbol
        elif nodeName_ == 'accession':
            obj_ = Accession.factory()
            obj_.build(child_)
            self.set_accession(obj_)
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = re_.sub(STRING_CLEANUP_PAT, " ", name_).strip()
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'location':
            location_ = child_.text
            location_ = re_.sub(STRING_CLEANUP_PAT, " ", location_).strip()
            location_ = self.gds_validate_string(location_, node, 'location')
            self.location = location_
        elif nodeName_ == 'mol_seq':
            obj_ = MolSeq.factory()
            obj_.build(child_)
            self.set_mol_seq(obj_)
        elif nodeName_ == 'uri':
            obj_ = Uri.factory()
            obj_.build(child_)
            self.set_uri(obj_)
        elif nodeName_ == 'annotation':
            obj_ = Annotation.factory()
            obj_.build(child_)
            self.annotation.append(obj_)
        elif nodeName_ == 'domain_architecture':
            obj_ = DomainArchitecture.factory()
            obj_.build(child_)
            self.set_domain_architecture(obj_)
# end class Sequence


class MolSeq(GeneratedsSuper):
    """Element 'mol_seq' is used to store molecular sequences. The
    'is_aligned' attribute is used to indicated that this molecular
    sequence is aligned with all other sequences in the same
    phylogeny for which 'is aligned' is true as well (which, in most
    cases, means that gaps were introduced, and that all sequences
    for which 'is aligned' is true must have the same length)."""
    subclass = None
    superclass = None
    def __init__(self, is_aligned=None, valueOf_=None):
        self.is_aligned = _cast(bool, is_aligned)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MolSeq.subclass:
            return MolSeq.subclass(*args_, **kwargs_)
        else:
            return MolSeq(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_is_aligned(self): return self.is_aligned
    def set_is_aligned(self, is_aligned): self.is_aligned = is_aligned
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='MolSeq', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MolSeq')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='MolSeq'):
        if self.is_aligned is not None and 'is_aligned' not in already_processed:
            already_processed.append('is_aligned')
            outfile.write(' is_aligned="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.is_aligned)), input_name='is_aligned'))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='MolSeq', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MolSeq'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_aligned is not None and 'is_aligned' not in already_processed:
            already_processed.append('is_aligned')
            showIndent(outfile, level)
            outfile.write('is_aligned = %s,\n' % (self.is_aligned,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_aligned', node)
        if value is not None and 'is_aligned' not in already_processed:
            already_processed.append('is_aligned')
            if value in ('true', '1'):
                self.is_aligned = True
            elif value in ('false', '0'):
                self.is_aligned = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MolSeq


class Accession(GeneratedsSuper):
    """Element Accession is used to capture the local part in a sequence
    identifier (e.g. 'P17304' in 'UniProtKB:P17304', in which case
    the 'source' attribute would be 'UniProtKB')."""
    subclass = None
    superclass = None
    def __init__(self, source=None, valueOf_=None):
        self.source = _cast(None, source)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Accession.subclass:
            return Accession.subclass(*args_, **kwargs_)
        else:
            return Accession(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='Accession', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Accession')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Accession'):
        if self.source is not None and 'source' not in already_processed:
            already_processed.append('source')
            outfile.write(' source=%s' % (self.gds_format_string(quote_attrib(self.source).encode(ExternalEncoding), input_name='source'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Accession', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Accession'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.source is not None and 'source' not in already_processed:
            already_processed.append('source')
            showIndent(outfile, level)
            outfile.write('source = "%s",\n' % (self.source,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.append('source')
            self.source = value
            self.source = ' '.join(self.source.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Accession


class DomainArchitecture(GeneratedsSuper):
    """This is used describe the domain architecture of a protein.
    Attribute 'length' is the total length of the protein"""
    subclass = None
    superclass = None
    def __init__(self, length=None, domain=None, valueOf_=None):
        self.length = _cast(int, length)
        if domain is None:
            self.domain = []
        else:
            self.domain = domain
    def factory(*args_, **kwargs_):
        if DomainArchitecture.subclass:
            return DomainArchitecture.subclass(*args_, **kwargs_)
        else:
            return DomainArchitecture(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_domain(self): return self.domain
    def set_domain(self, domain): self.domain = domain
    def add_domain(self, value): self.domain.append(value)
    def insert_domain(self, index, value): self.domain[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='phy:', name_='DomainArchitecture', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DomainArchitecture')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='DomainArchitecture'):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_integer(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='DomainArchitecture', fromsubclass_=False):
        for domain_ in self.domain:
            domain_.export(outfile, level, namespace_, name_='domain')
    def hasContent_(self):
        if (
            self.domain
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DomainArchitecture'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %d,\n' % (self.length,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('domain=[\n')
        level += 1
        for domain_ in self.domain:
            showIndent(outfile, level)
            outfile.write('model_.ProteinDomain(\n')
            domain_.exportLiteral(outfile, level, name_='ProteinDomain')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.length < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'domain':
            obj_ = ProteinDomain.factory()
            obj_.build(child_)
            self.domain.append(obj_)
# end class DomainArchitecture


class ProteinDomain(GeneratedsSuper):
    """To represent an individual domain in a domain architecture. The
    name/unique identifier is described via the 'id' attribute.
    'confidence' can be used to store (i.e.) E-values."""
    subclass = None
    superclass = None
    def __init__(self, to=None, confidence=None, fromxx=None, id=None, valueOf_=None):
        self.to = _cast(int, to)
        self.confidence = _cast(float, confidence)
        self.fromxx = _cast(int, fromxx)
        self.id = _cast(None, id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ProteinDomain.subclass:
            return ProteinDomain.subclass(*args_, **kwargs_)
        else:
            return ProteinDomain(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_to(self): return self.to
    def set_to(self, to): self.to = to
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def get_from(self): return self.fromxx
    def set_from(self, fromxx): self.fromxx = fromxx
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='ProteinDomain', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProteinDomain')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='ProteinDomain'):
        if self.to is not None and 'to' not in already_processed:
            already_processed.append('to')
            outfile.write(' to="%s"' % self.gds_format_integer(self.to, input_name='to'))
        if self.confidence is not None and 'confidence' not in already_processed:
            already_processed.append('confidence')
            outfile.write(' confidence="%s"' % self.gds_format_double(self.confidence, input_name='confidence'))
        if self.fromxx is not None and 'fromxx' not in already_processed:
            already_processed.append('fromxx')
            outfile.write(' from="%s"' % self.gds_format_integer(self.fromxx, input_name='from'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='ProteinDomain', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProteinDomain'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.to is not None and 'to' not in already_processed:
            already_processed.append('to')
            showIndent(outfile, level)
            outfile.write('to = %d,\n' % (self.to,))
        if self.confidence is not None and 'confidence' not in already_processed:
            already_processed.append('confidence')
            showIndent(outfile, level)
            outfile.write('confidence = %e,\n' % (self.confidence,))
        if self.fromxx is not None and 'fromxx' not in already_processed:
            already_processed.append('fromxx')
            showIndent(outfile, level)
            outfile.write('fromxx = %d,\n' % (self.fromxx,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.append('to')
            try:
                self.to = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.to < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('confidence', node)
        if value is not None and 'confidence' not in already_processed:
            already_processed.append('confidence')
            try:
                self.confidence = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (confidence): %s' % exp)
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.append('from')
            try:
                self.fromxx = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.fromxx < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
            self.id = ' '.join(self.id.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ProteinDomain


class Events(GeneratedsSuper):
    """Events at the root node of a clade (e.g. one gene duplication)."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, duplications=None, speciations=None, losses=None, confidence=None, valueOf_=None):
        self.type_ = type_
        self.duplications = duplications
        self.speciations = speciations
        self.losses = losses
        self.confidence = confidence
    def factory(*args_, **kwargs_):
        if Events.subclass:
            return Events.subclass(*args_, **kwargs_)
        else:
            return Events(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def validate_EventType(self, value):
        # Validate type EventType, a restriction on xs:token.
        pass
    def get_duplications(self): return self.duplications
    def set_duplications(self, duplications): self.duplications = duplications
    def get_speciations(self): return self.speciations
    def set_speciations(self, speciations): self.speciations = speciations
    def get_losses(self): return self.losses
    def set_losses(self, losses): self.losses = losses
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def export(self, outfile, level, namespace_='phy:', name_='Events', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Events')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Events'):
        pass
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Events', fromsubclass_=False):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_))
        if self.duplications is not None:
            showIndent(outfile, level)
            outfile.write('<%sduplications>%s</%sduplications>\n' % (namespace_, self.gds_format_integer(self.duplications, input_name='duplications'), namespace_))
        if self.speciations is not None:
            showIndent(outfile, level)
            outfile.write('<%sspeciations>%s</%sspeciations>\n' % (namespace_, self.gds_format_integer(self.speciations, input_name='speciations'), namespace_))
        if self.losses is not None:
            showIndent(outfile, level)
            outfile.write('<%slosses>%s</%slosses>\n' % (namespace_, self.gds_format_integer(self.losses, input_name='losses'), namespace_))
        if self.confidence:
            self.confidence.export(outfile, level, namespace_, name_='confidence')
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.duplications is not None or
            self.speciations is not None or
            self.losses is not None or
            self.confidence is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Events'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.duplications is not None:
            showIndent(outfile, level)
            outfile.write('duplications=%d,\n' % self.duplications)
        if self.speciations is not None:
            showIndent(outfile, level)
            outfile.write('speciations=%d,\n' % self.speciations)
        if self.losses is not None:
            showIndent(outfile, level)
            outfile.write('losses=%d,\n' % self.losses)
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence=model_.Confidence(\n')
            self.confidence.exportLiteral(outfile, level, name_='confidence')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'type':
            type_ = child_.text
            type_ = re_.sub(STRING_CLEANUP_PAT, " ", type_).strip()
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
            self.validate_EventType(self.type_)    # validate type EventType
        elif nodeName_ == 'duplications':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'duplications')
            self.duplications = ival_
        elif nodeName_ == 'speciations':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'speciations')
            self.speciations = ival_
        elif nodeName_ == 'losses':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'losses')
            self.losses = ival_
        elif nodeName_ == 'confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.set_confidence(obj_)
# end class Events


class BinaryCharacters(GeneratedsSuper):
    """The names and/or counts of binary characters present, gained, and
    lost at the root of a clade."""
    subclass = None
    superclass = None
    def __init__(self, lost_count=None, absent_count=None, present_count=None, type_=None, gained_count=None, gained=None, lost=None, present=None, absent=None, valueOf_=None):
        self.lost_count = _cast(int, lost_count)
        self.absent_count = _cast(int, absent_count)
        self.present_count = _cast(int, present_count)
        self.type_ = _cast(None, type_)
        self.gained_count = _cast(int, gained_count)
        self.gained = gained
        self.lost = lost
        self.present = present
        self.absent = absent
    def factory(*args_, **kwargs_):
        if BinaryCharacters.subclass:
            return BinaryCharacters.subclass(*args_, **kwargs_)
        else:
            return BinaryCharacters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_gained(self): return self.gained
    def set_gained(self, gained): self.gained = gained
    def get_lost(self): return self.lost
    def set_lost(self, lost): self.lost = lost
    def get_present(self): return self.present
    def set_present(self, present): self.present = present
    def get_absent(self): return self.absent
    def set_absent(self, absent): self.absent = absent
    def get_lost_count(self): return self.lost_count
    def set_lost_count(self, lost_count): self.lost_count = lost_count
    def get_absent_count(self): return self.absent_count
    def set_absent_count(self, absent_count): self.absent_count = absent_count
    def get_present_count(self): return self.present_count
    def set_present_count(self, present_count): self.present_count = present_count
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_gained_count(self): return self.gained_count
    def set_gained_count(self, gained_count): self.gained_count = gained_count
    def export(self, outfile, level, namespace_='phy:', name_='BinaryCharacters', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BinaryCharacters')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='BinaryCharacters'):
        if self.lost_count is not None and 'lost_count' not in already_processed:
            already_processed.append('lost_count')
            outfile.write(' lost_count="%s"' % self.gds_format_integer(self.lost_count, input_name='lost_count'))
        if self.absent_count is not None and 'absent_count' not in already_processed:
            already_processed.append('absent_count')
            outfile.write(' absent_count="%s"' % self.gds_format_integer(self.absent_count, input_name='absent_count'))
        if self.present_count is not None and 'present_count' not in already_processed:
            already_processed.append('present_count')
            outfile.write(' present_count="%s"' % self.gds_format_integer(self.present_count, input_name='present_count'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.gained_count is not None and 'gained_count' not in already_processed:
            already_processed.append('gained_count')
            outfile.write(' gained_count="%s"' % self.gds_format_integer(self.gained_count, input_name='gained_count'))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='BinaryCharacters', fromsubclass_=False):
        if self.gained:
            self.gained.export(outfile, level, namespace_, name_='gained')
        if self.lost:
            self.lost.export(outfile, level, namespace_, name_='lost')
        if self.present:
            self.present.export(outfile, level, namespace_, name_='present')
        if self.absent:
            self.absent.export(outfile, level, namespace_, name_='absent')
    def hasContent_(self):
        if (
            self.gained is not None or
            self.lost is not None or
            self.present is not None or
            self.absent is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BinaryCharacters'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.lost_count is not None and 'lost_count' not in already_processed:
            already_processed.append('lost_count')
            showIndent(outfile, level)
            outfile.write('lost_count = %d,\n' % (self.lost_count,))
        if self.absent_count is not None and 'absent_count' not in already_processed:
            already_processed.append('absent_count')
            showIndent(outfile, level)
            outfile.write('absent_count = %d,\n' % (self.absent_count,))
        if self.present_count is not None and 'present_count' not in already_processed:
            already_processed.append('present_count')
            showIndent(outfile, level)
            outfile.write('present_count = %d,\n' % (self.present_count,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.gained_count is not None and 'gained_count' not in already_processed:
            already_processed.append('gained_count')
            showIndent(outfile, level)
            outfile.write('gained_count = %d,\n' % (self.gained_count,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.gained is not None:
            showIndent(outfile, level)
            outfile.write('gained=model_.BinaryCharacterList(\n')
            self.gained.exportLiteral(outfile, level, name_='gained')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.lost is not None:
            showIndent(outfile, level)
            outfile.write('lost=model_.BinaryCharacterList(\n')
            self.lost.exportLiteral(outfile, level, name_='lost')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.present is not None:
            showIndent(outfile, level)
            outfile.write('present=model_.BinaryCharacterList(\n')
            self.present.exportLiteral(outfile, level, name_='present')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.absent is not None:
            showIndent(outfile, level)
            outfile.write('absent=model_.BinaryCharacterList(\n')
            self.absent.exportLiteral(outfile, level, name_='absent')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lost_count', node)
        if value is not None and 'lost_count' not in already_processed:
            already_processed.append('lost_count')
            try:
                self.lost_count = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.lost_count < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('absent_count', node)
        if value is not None and 'absent_count' not in already_processed:
            already_processed.append('absent_count')
            try:
                self.absent_count = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.absent_count < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('present_count', node)
        if value is not None and 'present_count' not in already_processed:
            already_processed.append('present_count')
            try:
                self.present_count = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.present_count < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('gained_count', node)
        if value is not None and 'gained_count' not in already_processed:
            already_processed.append('gained_count')
            try:
                self.gained_count = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.gained_count < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gained':
            obj_ = BinaryCharacterList.factory()
            obj_.build(child_)
            self.set_gained(obj_)
        elif nodeName_ == 'lost':
            obj_ = BinaryCharacterList.factory()
            obj_.build(child_)
            self.set_lost(obj_)
        elif nodeName_ == 'present':
            obj_ = BinaryCharacterList.factory()
            obj_.build(child_)
            self.set_present(obj_)
        elif nodeName_ == 'absent':
            obj_ = BinaryCharacterList.factory()
            obj_.build(child_)
            self.set_absent(obj_)
# end class BinaryCharacters


class BinaryCharacterList(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, bc=None, valueOf_=None):
        if bc is None:
            self.bc = []
        else:
            self.bc = bc
    def factory(*args_, **kwargs_):
        if BinaryCharacterList.subclass:
            return BinaryCharacterList.subclass(*args_, **kwargs_)
        else:
            return BinaryCharacterList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_bc(self): return self.bc
    def set_bc(self, bc): self.bc = bc
    def add_bc(self, value): self.bc.append(value)
    def insert_bc(self, index, value): self.bc[index] = value
    def export(self, outfile, level, namespace_='phy:', name_='BinaryCharacterList', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BinaryCharacterList')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='BinaryCharacterList'):
        pass
    def exportChildren(self, outfile, level, namespace_='phy:', name_='BinaryCharacterList', fromsubclass_=False):
        for bc_ in self.bc:
            showIndent(outfile, level)
            outfile.write('<%sbc>%s</%sbc>\n' % (namespace_, self.gds_format_string(quote_xml(bc_).encode(ExternalEncoding), input_name='bc'), namespace_))
    def hasContent_(self):
        if (
            self.bc
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BinaryCharacterList'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('bc=[\n')
        level += 1
        for bc_ in self.bc:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(bc_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'bc':
            bc_ = child_.text
            bc_ = re_.sub(STRING_CLEANUP_PAT, " ", bc_).strip()
            bc_ = self.gds_validate_string(bc_, node, 'bc')
            self.bc.append(bc_)
# end class BinaryCharacterList


class Reference(GeneratedsSuper):
    """A literature reference for a clade. It is recommended to use the
    'doi' attribute instead of the free text 'desc' element whenever
    possible."""
    subclass = None
    superclass = None
    def __init__(self, doi=None, desc=None, valueOf_=None):
        self.doi = _cast(None, doi)
        self.desc = desc
    def factory(*args_, **kwargs_):
        if Reference.subclass:
            return Reference.subclass(*args_, **kwargs_)
        else:
            return Reference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    def get_doi(self): return self.doi
    def set_doi(self, doi): self.doi = doi
    def export(self, outfile, level, namespace_='phy:', name_='Reference', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Reference')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Reference'):
        if self.doi is not None and 'doi' not in already_processed:
            already_processed.append('doi')
            outfile.write(' doi=%s' % (quote_attrib(self.doi), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Reference', fromsubclass_=False):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('<%sdesc>%s</%sdesc>\n' % (namespace_, self.gds_format_string(quote_xml(self.desc).encode(ExternalEncoding), input_name='desc'), namespace_))
    def hasContent_(self):
        if (
            self.desc is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Reference'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.doi is not None and 'doi' not in already_processed:
            already_processed.append('doi')
            showIndent(outfile, level)
            outfile.write('doi = %s,\n' % (self.doi,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('desc=%s,\n' % quote_python(self.desc).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('doi', node)
        if value is not None and 'doi' not in already_processed:
            already_processed.append('doi')
            self.doi = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'desc':
            desc_ = child_.text
            desc_ = re_.sub(STRING_CLEANUP_PAT, " ", desc_).strip()
            desc_ = self.gds_validate_string(desc_, node, 'desc')
            self.desc = desc_
# end class Reference


class Annotation(GeneratedsSuper):
    """The annotation of a molecular sequence. It is recommended to
    annotate by using the optional 'ref' attribute (some examples of
    acceptable values for the ref attribute: 'GO:0008270',
    'KEGG:Tetrachloroethene degradation', 'EC:1.1.1.1'). Optional
    element 'desc' allows for a free text description. Optional
    element 'confidence' is used to state the type and value of
    support for a annotation. Similarly, optional attribute
    'evidence' is used to describe the evidence for a annotation as
    free text (e.g. 'experimental'). Optional element 'property'
    allows for further, typed and referenced annotations from
    external resources."""
    subclass = None
    superclass = None
    def __init__(self, source=None, type_=None, ref=None, evidence=None, desc=None, confidence=None, property=None, uri=None, valueOf_=None):
        self.source = _cast(None, source)
        self.type_ = _cast(None, type_)
        self.ref = _cast(None, ref)
        self.evidence = _cast(None, evidence)
        self.desc = desc
        self.confidence = confidence
        if property is None:
            self.property = []
        else:
            self.property = property
        self.uri = uri
    def factory(*args_, **kwargs_):
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def get_property(self): return self.property
    def set_property(self, property): self.property = property
    def add_property(self, value): self.property.append(value)
    def insert_property(self, index, value): self.property[index] = value
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_ref(self): return self.ref
    def set_ref(self, ref): self.ref = ref
    def get_evidence(self): return self.evidence
    def set_evidence(self, evidence): self.evidence = evidence
    def export(self, outfile, level, namespace_='phy:', name_='Annotation', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Annotation')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Annotation'):
        if self.source is not None and 'source' not in already_processed:
            already_processed.append('source')
            outfile.write(' source=%s' % (self.gds_format_string(quote_attrib(self.source).encode(ExternalEncoding), input_name='source'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.ref is not None and 'ref' not in already_processed:
            already_processed.append('ref')
            outfile.write(' ref=%s' % (quote_attrib(self.ref), ))
        if self.evidence is not None and 'evidence' not in already_processed:
            already_processed.append('evidence')
            outfile.write(' evidence=%s' % (self.gds_format_string(quote_attrib(self.evidence).encode(ExternalEncoding), input_name='evidence'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Annotation', fromsubclass_=False):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('<%sdesc>%s</%sdesc>\n' % (namespace_, self.gds_format_string(quote_xml(self.desc).encode(ExternalEncoding), input_name='desc'), namespace_))
        if self.confidence:
            self.confidence.export(outfile, level, namespace_, name_='confidence')
        for property_ in self.property:
            property_.export(outfile, level, namespace_, name_='property')
        if self.uri:
            self.uri.export(outfile, level, namespace_, name_='uri')
    def hasContent_(self):
        if (
            self.desc is not None or
            self.confidence is not None or
            self.property or
            self.uri is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Annotation'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.source is not None and 'source' not in already_processed:
            already_processed.append('source')
            showIndent(outfile, level)
            outfile.write('source = "%s",\n' % (self.source,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.ref is not None and 'ref' not in already_processed:
            already_processed.append('ref')
            showIndent(outfile, level)
            outfile.write('ref = %s,\n' % (self.ref,))
        if self.evidence is not None and 'evidence' not in already_processed:
            already_processed.append('evidence')
            showIndent(outfile, level)
            outfile.write('evidence = "%s",\n' % (self.evidence,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('desc=%s,\n' % quote_python(self.desc).encode(ExternalEncoding))
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence=model_.Confidence(\n')
            self.confidence.exportLiteral(outfile, level, name_='confidence')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('property=[\n')
        level += 1
        for property_ in self.property:
            showIndent(outfile, level)
            outfile.write('model_.Property(\n')
            property_.exportLiteral(outfile, level, name_='Property')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=model_.Uri(\n')
            self.uri.exportLiteral(outfile, level, name_='uri')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.append('source')
            self.source = value
            self.source = ' '.join(self.source.split())
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('ref', node)
        if value is not None and 'ref' not in already_processed:
            already_processed.append('ref')
            self.ref = value
        value = find_attr_value_('evidence', node)
        if value is not None and 'evidence' not in already_processed:
            already_processed.append('evidence')
            self.evidence = value
            self.evidence = ' '.join(self.evidence.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'desc':
            desc_ = child_.text
            desc_ = re_.sub(STRING_CLEANUP_PAT, " ", desc_).strip()
            desc_ = self.gds_validate_string(desc_, node, 'desc')
            self.desc = desc_
        elif nodeName_ == 'confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.set_confidence(obj_)
        elif nodeName_ == 'property':
            obj_ = Property.factory()
            obj_.build(child_)
            self.property.append(obj_)
        elif nodeName_ == 'uri':
            obj_ = Uri.factory()
            obj_.build(child_)
            self.set_uri(obj_)
# end class Annotation


class Property(GeneratedsSuper):
    """Property allows for typed and referenced properties from external
    resources to be attached to 'Phylogeny', 'Clade', and
    'Annotation'. The value of a property is its mixed (free text)
    content. Attribute 'datatype' indicates the type of a property
    and is limited to xsd-datatypes (e.g. 'xsd:string',
    'xsd:boolean', 'xsd:integer', 'xsd:decimal', 'xsd:float',
    'xsd:double', 'xsd:date', 'xsd:anyURI'). Attribute 'applies_to'
    indicates the item to which a property applies to (e.g. 'node'
    for the parent node of a clade, 'parent_branch' for the parent
    branch of a clade). Attribute 'id_ref' allows to attached a
    property specifically to one element (on the xml-level).
    Optional attribute 'unit' is used to indicate the unit of the
    property. An example: <property datatype="xsd:integer"
    ref="NOAA:depth" applies_to="clade" unit="METRIC:m"> 200
    </property>"""
    subclass = None
    superclass = None
    def __init__(self, datatype=None, id_ref=None, ref=None, applies_to=None, unit=None, valueOf_=None, mixedclass_=None, content_=None):
        self.datatype = _cast(None, datatype)
        self.id_ref = _cast(None, id_ref)
        self.ref = _cast(None, ref)
        self.applies_to = _cast(None, applies_to)
        self.unit = _cast(None, unit)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Property.subclass:
            return Property.subclass(*args_, **kwargs_)
        else:
            return Property(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_id_ref(self): return self.id_ref
    def set_id_ref(self, id_ref): self.id_ref = id_ref
    def get_ref(self): return self.ref
    def set_ref(self, ref): self.ref = ref
    def get_applies_to(self): return self.applies_to
    def set_applies_to(self, applies_to): self.applies_to = applies_to
    def get_unit(self): return self.unit
    def set_unit(self, unit): self.unit = unit
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='Property', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Property')
        outfile.write('>')
        if self.valueOf_ is not None:
            outfile.write('%s' % (self.valueOf_,))
        self.exportChildren(outfile, level + 1, namespace_, name_)
        outfile.write('</%s%s>\n' % (namespace_, name_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Property'):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
        if self.id_ref is not None and 'id_ref' not in already_processed:
            already_processed.append('id_ref')
            outfile.write(' id_ref=%s' % (quote_attrib(self.id_ref), ))
        if self.ref is not None and 'ref' not in already_processed:
            already_processed.append('ref')
            outfile.write(' ref=%s' % (quote_attrib(self.ref), ))
        if self.applies_to is not None and 'applies_to' not in already_processed:
            already_processed.append('applies_to')
            outfile.write(' applies_to=%s' % (quote_attrib(self.applies_to), ))
        if self.unit is not None and 'unit' not in already_processed:
            already_processed.append('unit')
            outfile.write(' unit=%s' % (quote_attrib(self.unit), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Property', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Property'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        if self.id_ref is not None and 'id_ref' not in already_processed:
            already_processed.append('id_ref')
            showIndent(outfile, level)
            outfile.write('id_ref = %s,\n' % (self.id_ref,))
        if self.ref is not None and 'ref' not in already_processed:
            already_processed.append('ref')
            showIndent(outfile, level)
            outfile.write('ref = %s,\n' % (self.ref,))
        if self.applies_to is not None and 'applies_to' not in already_processed:
            already_processed.append('applies_to')
            showIndent(outfile, level)
            outfile.write('applies_to = %s,\n' % (self.applies_to,))
        if self.unit is not None and 'unit' not in already_processed:
            already_processed.append('unit')
            showIndent(outfile, level)
            outfile.write('unit = %s,\n' % (self.unit,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        value = find_attr_value_('id_ref', node)
        if value is not None and 'id_ref' not in already_processed:
            already_processed.append('id_ref')
            self.id_ref = value
        value = find_attr_value_('ref', node)
        if value is not None and 'ref' not in already_processed:
            already_processed.append('ref')
            self.ref = value
        value = find_attr_value_('applies_to', node)
        if value is not None and 'applies_to' not in already_processed:
            already_processed.append('applies_to')
            self.applies_to = value
        value = find_attr_value_('unit', node)
        if value is not None and 'unit' not in already_processed:
            already_processed.append('unit')
            self.unit = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class Property


class Uri(GeneratedsSuper):
    """A uniform resource identifier. In general, this is expected to be an
    URL (for example, to link to an image on a website, in which
    case the 'type' attribute might be 'image' and 'desc' might be
    'image of a California sea hare')."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, desc=None, valueOf_=None):
        self.type_ = _cast(None, type_)
        self.desc = _cast(None, desc)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Uri.subclass:
            return Uri.subclass(*args_, **kwargs_)
        else:
            return Uri(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='Uri', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Uri')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Uri'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.append('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc).encode(ExternalEncoding), input_name='desc'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Uri', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Uri'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.append('desc')
            showIndent(outfile, level)
            outfile.write('desc = "%s",\n' % (self.desc,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.append('desc')
            self.desc = value
            self.desc = ' '.join(self.desc.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Uri


class Confidence(GeneratedsSuper):
    """A general purpose confidence element. For example this can be used
    to express the bootstrap support value of a clade (in which case
    the 'type' attribute is 'bootstrap')."""
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Confidence.subclass:
            return Confidence.subclass(*args_, **kwargs_)
        else:
            return Confidence(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='Confidence', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Confidence')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Confidence'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Confidence', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Confidence'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Confidence


class Id(GeneratedsSuper):
    """A general purpose identifier element. Allows to indicate the
    provider (or authority) of an identifier."""
    subclass = None
    superclass = None
    def __init__(self, provider=None, valueOf_=None):
        self.provider = _cast(None, provider)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Id.subclass:
            return Id.subclass(*args_, **kwargs_)
        else:
            return Id(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_provider(self): return self.provider
    def set_provider(self, provider): self.provider = provider
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='phy:', name_='Id', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Id')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Id'):
        if self.provider is not None and 'provider' not in already_processed:
            already_processed.append('provider')
            outfile.write(' provider=%s' % (self.gds_format_string(quote_attrib(self.provider).encode(ExternalEncoding), input_name='provider'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Id', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Id'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.provider is not None and 'provider' not in already_processed:
            already_processed.append('provider')
            showIndent(outfile, level)
            outfile.write('provider = "%s",\n' % (self.provider,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('provider', node)
        if value is not None and 'provider' not in already_processed:
            already_processed.append('provider')
            self.provider = value
            self.provider = ' '.join(self.provider.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Id


class Distribution(GeneratedsSuper):
    """The geographic distribution of the items of a clade (species,
    sequences), intended for phylogeographic applications. The
    location can be described either by free text in the 'desc'
    element and/or by the coordinates of one or more 'Points'
    (similar to the 'Point' element in Google's KML format) or by
    'Polygons'."""
    subclass = None
    superclass = None
    def __init__(self, desc=None, point=None, polygon=None, valueOf_=None):
        self.desc = desc
        if point is None:
            self.point = []
        else:
            self.point = point
        if polygon is None:
            self.polygon = []
        else:
            self.polygon = polygon
    def factory(*args_, **kwargs_):
        if Distribution.subclass:
            return Distribution.subclass(*args_, **kwargs_)
        else:
            return Distribution(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    def get_point(self): return self.point
    def set_point(self, point): self.point = point
    def add_point(self, value): self.point.append(value)
    def insert_point(self, index, value): self.point[index] = value
    def get_polygon(self): return self.polygon
    def set_polygon(self, polygon): self.polygon = polygon
    def add_polygon(self, value): self.polygon.append(value)
    def insert_polygon(self, index, value): self.polygon[index] = value
    def export(self, outfile, level, namespace_='phy:', name_='Distribution', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Distribution')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Distribution'):
        pass
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Distribution', fromsubclass_=False):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('<%sdesc>%s</%sdesc>\n' % (namespace_, self.gds_format_string(quote_xml(self.desc).encode(ExternalEncoding), input_name='desc'), namespace_))
        for point_ in self.point:
            point_.export(outfile, level, namespace_, name_='point')
        for polygon_ in self.polygon:
            polygon_.export(outfile, level, namespace_, name_='polygon')
    def hasContent_(self):
        if (
            self.desc is not None or
            self.point or
            self.polygon
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Distribution'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('desc=%s,\n' % quote_python(self.desc).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('point=[\n')
        level += 1
        for point_ in self.point:
            showIndent(outfile, level)
            outfile.write('model_.Point(\n')
            point_.exportLiteral(outfile, level, name_='Point')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('polygon=[\n')
        level += 1
        for polygon_ in self.polygon:
            showIndent(outfile, level)
            outfile.write('model_.Polygon(\n')
            polygon_.exportLiteral(outfile, level, name_='Polygon')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'desc':
            desc_ = child_.text
            desc_ = re_.sub(STRING_CLEANUP_PAT, " ", desc_).strip()
            desc_ = self.gds_validate_string(desc_, node, 'desc')
            self.desc = desc_
        elif nodeName_ == 'point':
            obj_ = Point.factory()
            obj_.build(child_)
            self.point.append(obj_)
        elif nodeName_ == 'polygon':
            obj_ = Polygon.factory()
            obj_.build(child_)
            self.polygon.append(obj_)
# end class Distribution


class Point(GeneratedsSuper):
    """The coordinates of a point with an optional altitude (used by
    element 'Distribution'). Required attributes are the
    'geodetic_datum' used to indicate the geodetic datum (also
    called 'map datum', for example Google's KML uses 'WGS84').
    Attribute 'alt_unit' is the unit for the altitude (e.g.
    'meter')."""
    subclass = None
    superclass = None
    def __init__(self, geodetic_datum=None, alt_unit=None, lat=None, long=None, alt=None, valueOf_=None):
        self.geodetic_datum = _cast(None, geodetic_datum)
        self.alt_unit = _cast(None, alt_unit)
        self.lat = lat
        self.long = int
        self.alt = alt
    def factory(*args_, **kwargs_):
        if Point.subclass:
            return Point.subclass(*args_, **kwargs_)
        else:
            return Point(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lat(self): return self.lat
    def set_lat(self, lat): self.lat = lat
    def get_long(self): return self.long
    def set_long(self, long): self.long = int
    def get_alt(self): return self.alt
    def set_alt(self, alt): self.alt = alt
    def get_geodetic_datum(self): return self.geodetic_datum
    def set_geodetic_datum(self, geodetic_datum): self.geodetic_datum = geodetic_datum
    def get_alt_unit(self): return self.alt_unit
    def set_alt_unit(self, alt_unit): self.alt_unit = alt_unit
    def export(self, outfile, level, namespace_='phy:', name_='Point', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Point')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Point'):
        if self.geodetic_datum is not None and 'geodetic_datum' not in already_processed:
            already_processed.append('geodetic_datum')
            outfile.write(' geodetic_datum=%s' % (self.gds_format_string(quote_attrib(self.geodetic_datum).encode(ExternalEncoding), input_name='geodetic_datum'), ))
        if self.alt_unit is not None and 'alt_unit' not in already_processed:
            already_processed.append('alt_unit')
            outfile.write(' alt_unit=%s' % (self.gds_format_string(quote_attrib(self.alt_unit).encode(ExternalEncoding), input_name='alt_unit'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Point', fromsubclass_=False):
        if self.lat is not None:
            showIndent(outfile, level)
            outfile.write('<%slat>%s</%slat>\n' % (namespace_, self.gds_format_float(self.lat, input_name='lat'), namespace_))
        if self.long is not None:
            showIndent(outfile, level)
            outfile.write('<%slong>%s</%slong>\n' % (namespace_, self.gds_format_float(self.long, input_name='long'), namespace_))
        if self.alt is not None:
            showIndent(outfile, level)
            outfile.write('<%salt>%s</%salt>\n' % (namespace_, self.gds_format_float(self.alt, input_name='alt'), namespace_))
    def hasContent_(self):
        if (
            self.lat is not None or
            self.long is not None or
            self.alt is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Point'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.geodetic_datum is not None and 'geodetic_datum' not in already_processed:
            already_processed.append('geodetic_datum')
            showIndent(outfile, level)
            outfile.write('geodetic_datum = "%s",\n' % (self.geodetic_datum,))
        if self.alt_unit is not None and 'alt_unit' not in already_processed:
            already_processed.append('alt_unit')
            showIndent(outfile, level)
            outfile.write('alt_unit = "%s",\n' % (self.alt_unit,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.lat is not None:
            showIndent(outfile, level)
            outfile.write('lat=%f,\n' % self.lat)
        if self.long is not None:
            showIndent(outfile, level)
            outfile.write('long=%f,\n' % self.long)
        if self.alt is not None:
            showIndent(outfile, level)
            outfile.write('alt=%f,\n' % self.alt)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('geodetic_datum', node)
        if value is not None and 'geodetic_datum' not in already_processed:
            already_processed.append('geodetic_datum')
            self.geodetic_datum = value
            self.geodetic_datum = ' '.join(self.geodetic_datum.split())
        value = find_attr_value_('alt_unit', node)
        if value is not None and 'alt_unit' not in already_processed:
            already_processed.append('alt_unit')
            self.alt_unit = value
            self.alt_unit = ' '.join(self.alt_unit.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'lat':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'lat')
            self.lat = fval_
        elif nodeName_ == 'long':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'long')
            self.long = fval_
        elif nodeName_ == 'alt':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'alt')
            self.alt = fval_
# end class Point


class Polygon(GeneratedsSuper):
    """A polygon defined by a list of 'Points' (used by element
    'Distribution')."""
    subclass = None
    superclass = None
    def __init__(self, point=None, valueOf_=None):
        if point is None:
            self.point = []
        else:
            self.point = point
    def factory(*args_, **kwargs_):
        if Polygon.subclass:
            return Polygon.subclass(*args_, **kwargs_)
        else:
            return Polygon(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_point(self): return self.point
    def set_point(self, point): self.point = point
    def add_point(self, value): self.point.append(value)
    def insert_point(self, index, value): self.point[index] = value
    def export(self, outfile, level, namespace_='phy:', name_='Polygon', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Polygon')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Polygon'):
        pass
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Polygon', fromsubclass_=False):
        for point_ in self.point:
            point_.export(outfile, level, namespace_, name_='point')
    def hasContent_(self):
        if (
            self.point
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Polygon'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('point=[\n')
        level += 1
        for point_ in self.point:
            showIndent(outfile, level)
            outfile.write('model_.Point(\n')
            point_.exportLiteral(outfile, level, name_='Point')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'point':
            obj_ = Point.factory()
            obj_.build(child_)
            self.point.append(obj_)
# end class Polygon


class Date(GeneratedsSuper):
    """A date associated with a clade/node. Its value can be numerical by
    using the 'value' element and/or free text with the 'desc'
    element' (e.g. 'Silurian'). If a numerical value is used, it is
    recommended to employ the 'unit' attribute to indicate the type
    of the numerical value (e.g. 'mya' for 'million years ago'). The
    elements 'minimum' and 'maximum' are used the indicate a
    range/confidence interval"""
    subclass = None
    superclass = None
    def __init__(self, unit=None, desc=None, value=None, minimum=None, maximum=None, valueOf_=None):
        self.unit = _cast(None, unit)
        self.desc = desc
        self.value = value
        self.minimum = minimum
        self.maximum = maximum
    def factory(*args_, **kwargs_):
        if Date.subclass:
            return Date.subclass(*args_, **kwargs_)
        else:
            return Date(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_minimum(self): return self.minimum
    def set_minimum(self, minimum): self.minimum = minimum
    def get_maximum(self): return self.maximum
    def set_maximum(self, maximum): self.maximum = maximum
    def get_unit(self): return self.unit
    def set_unit(self, unit): self.unit = unit
    def export(self, outfile, level, namespace_='phy:', name_='Date', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Date')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='Date'):
        if self.unit is not None and 'unit' not in already_processed:
            already_processed.append('unit')
            outfile.write(' unit=%s' % (self.gds_format_string(quote_attrib(self.unit).encode(ExternalEncoding), input_name='unit'), ))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='Date', fromsubclass_=False):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('<%sdesc>%s</%sdesc>\n' % (namespace_, self.gds_format_string(quote_xml(self.desc).encode(ExternalEncoding), input_name='desc'), namespace_))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('<%svalue>%s</%svalue>\n' % (namespace_, self.gds_format_float(self.value, input_name='value'), namespace_))
        if self.minimum is not None:
            showIndent(outfile, level)
            outfile.write('<%sminimum>%s</%sminimum>\n' % (namespace_, self.gds_format_float(self.minimum, input_name='minimum'), namespace_))
        if self.maximum is not None:
            showIndent(outfile, level)
            outfile.write('<%smaximum>%s</%smaximum>\n' % (namespace_, self.gds_format_float(self.maximum, input_name='maximum'), namespace_))
    def hasContent_(self):
        if (
            self.desc is not None or
            self.value is not None or
            self.minimum is not None or
            self.maximum is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Date'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.unit is not None and 'unit' not in already_processed:
            already_processed.append('unit')
            showIndent(outfile, level)
            outfile.write('unit = "%s",\n' % (self.unit,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.desc is not None:
            showIndent(outfile, level)
            outfile.write('desc=%s,\n' % quote_python(self.desc).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%f,\n' % self.value)
        if self.minimum is not None:
            showIndent(outfile, level)
            outfile.write('minimum=%f,\n' % self.minimum)
        if self.maximum is not None:
            showIndent(outfile, level)
            outfile.write('maximum=%f,\n' % self.maximum)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('unit', node)
        if value is not None and 'unit' not in already_processed:
            already_processed.append('unit')
            self.unit = value
            self.unit = ' '.join(self.unit.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'desc':
            desc_ = child_.text
            desc_ = re_.sub(STRING_CLEANUP_PAT, " ", desc_).strip()
            desc_ = self.gds_validate_string(desc_, node, 'desc')
            self.desc = desc_
        elif nodeName_ == 'value':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'value')
            self.value = fval_
        elif nodeName_ == 'minimum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'minimum')
            self.minimum = fval_
        elif nodeName_ == 'maximum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'maximum')
            self.maximum = fval_
# end class Date


class BranchColor(GeneratedsSuper):
    """This indicates the color of a clade when rendered (the color applies
    to the whole clade unless overwritten by the color(s) of sub
    clades)."""
    subclass = None
    superclass = None
    def __init__(self, red=None, green=None, blue=None, valueOf_=None):
        self.red = red
        self.green = green
        self.blue = blue
    def factory(*args_, **kwargs_):
        if BranchColor.subclass:
            return BranchColor.subclass(*args_, **kwargs_)
        else:
            return BranchColor(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_red(self): return self.red
    def set_red(self, red): self.red = red
    def get_green(self): return self.green
    def set_green(self, green): self.green = green
    def get_blue(self): return self.blue
    def set_blue(self, blue): self.blue = blue
    def export(self, outfile, level, namespace_='phy:', name_='BranchColor', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BranchColor')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='BranchColor'):
        pass
    def exportChildren(self, outfile, level, namespace_='phy:', name_='BranchColor', fromsubclass_=False):
        if self.red is not None:
            showIndent(outfile, level)
            outfile.write('<%sred>%s</%sred>\n' % (namespace_, self.gds_format_integer(self.red, input_name='red'), namespace_))
        if self.green is not None:
            showIndent(outfile, level)
            outfile.write('<%sgreen>%s</%sgreen>\n' % (namespace_, self.gds_format_integer(self.green, input_name='green'), namespace_))
        if self.blue is not None:
            showIndent(outfile, level)
            outfile.write('<%sblue>%s</%sblue>\n' % (namespace_, self.gds_format_integer(self.blue, input_name='blue'), namespace_))
    def hasContent_(self):
        if (
            self.red is not None or
            self.green is not None or
            self.blue is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BranchColor'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.red is not None:
            showIndent(outfile, level)
            outfile.write('red=%d,\n' % self.red)
        if self.green is not None:
            showIndent(outfile, level)
            outfile.write('green=%d,\n' % self.green)
        if self.blue is not None:
            showIndent(outfile, level)
            outfile.write('blue=%d,\n' % self.blue)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'red':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'red')
            self.red = ival_
        elif nodeName_ == 'green':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'green')
            self.green = ival_
        elif nodeName_ == 'blue':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'blue')
            self.blue = ival_
# end class BranchColor


class SequenceRelation(GeneratedsSuper):
    """This is used to express a typed relationship between two sequences.
    For example it could be used to describe an orthology (in which
    case attribute 'type' is 'orthology')."""
    subclass = None
    superclass = None
    def __init__(self, id_ref_0=None, id_ref_1=None, type_=None, distance=None, confidence=None, valueOf_=None):
        self.id_ref_0 = _cast(None, id_ref_0)
        self.id_ref_1 = _cast(None, id_ref_1)
        self.type_ = _cast(None, type_)
        self.distance = _cast(float, distance)
        self.confidence = confidence
    def factory(*args_, **kwargs_):
        if SequenceRelation.subclass:
            return SequenceRelation.subclass(*args_, **kwargs_)
        else:
            return SequenceRelation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def get_id_ref_0(self): return self.id_ref_0
    def set_id_ref_0(self, id_ref_0): self.id_ref_0 = id_ref_0
    def get_id_ref_1(self): return self.id_ref_1
    def set_id_ref_1(self, id_ref_1): self.id_ref_1 = id_ref_1
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_distance(self): return self.distance
    def set_distance(self, distance): self.distance = distance
    def export(self, outfile, level, namespace_='phy:', name_='SequenceRelation', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SequenceRelation')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='SequenceRelation'):
        if self.id_ref_0 is not None and 'id_ref_0' not in already_processed:
            already_processed.append('id_ref_0')
            outfile.write(' id_ref_0=%s' % (quote_attrib(self.id_ref_0), ))
        if self.id_ref_1 is not None and 'id_ref_1' not in already_processed:
            already_processed.append('id_ref_1')
            outfile.write(' id_ref_1=%s' % (quote_attrib(self.id_ref_1), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.distance is not None and 'distance' not in already_processed:
            already_processed.append('distance')
            outfile.write(' distance="%s"' % self.gds_format_double(self.distance, input_name='distance'))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='SequenceRelation', fromsubclass_=False):
        if self.confidence:
            self.confidence.export(outfile, level, namespace_, name_='confidence')
    def hasContent_(self):
        if (
            self.confidence is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SequenceRelation'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id_ref_0 is not None and 'id_ref_0' not in already_processed:
            already_processed.append('id_ref_0')
            showIndent(outfile, level)
            outfile.write('id_ref_0 = %s,\n' % (self.id_ref_0,))
        if self.id_ref_1 is not None and 'id_ref_1' not in already_processed:
            already_processed.append('id_ref_1')
            showIndent(outfile, level)
            outfile.write('id_ref_1 = %s,\n' % (self.id_ref_1,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.distance is not None and 'distance' not in already_processed:
            already_processed.append('distance')
            showIndent(outfile, level)
            outfile.write('distance = %e,\n' % (self.distance,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence=model_.Confidence(\n')
            self.confidence.exportLiteral(outfile, level, name_='confidence')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id_ref_0', node)
        if value is not None and 'id_ref_0' not in already_processed:
            already_processed.append('id_ref_0')
            self.id_ref_0 = value
        value = find_attr_value_('id_ref_1', node)
        if value is not None and 'id_ref_1' not in already_processed:
            already_processed.append('id_ref_1')
            self.id_ref_1 = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
        value = find_attr_value_('distance', node)
        if value is not None and 'distance' not in already_processed:
            already_processed.append('distance')
            try:
                self.distance = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (distance): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.set_confidence(obj_)
# end class SequenceRelation


class CladeRelation(GeneratedsSuper):
    """This is used to express a typed relationship between two clades. For
    example it could be used to describe multiple parents of a
    clade."""
    subclass = None
    superclass = None
    def __init__(self, id_ref_0=None, id_ref_1=None, type_=None, distance=None, confidence=None, valueOf_=None):
        self.id_ref_0 = _cast(None, id_ref_0)
        self.id_ref_1 = _cast(None, id_ref_1)
        self.type_ = _cast(None, type_)
        self.distance = _cast(float, distance)
        self.confidence = confidence
    def factory(*args_, **kwargs_):
        if CladeRelation.subclass:
            return CladeRelation.subclass(*args_, **kwargs_)
        else:
            return CladeRelation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_confidence(self): return self.confidence
    def set_confidence(self, confidence): self.confidence = confidence
    def get_id_ref_0(self): return self.id_ref_0
    def set_id_ref_0(self, id_ref_0): self.id_ref_0 = id_ref_0
    def get_id_ref_1(self): return self.id_ref_1
    def set_id_ref_1(self, id_ref_1): self.id_ref_1 = id_ref_1
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_distance(self): return self.distance
    def set_distance(self, distance): self.distance = distance
    def export(self, outfile, level, namespace_='phy:', name_='CladeRelation', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CladeRelation')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='phy:', name_='CladeRelation'):
        if self.id_ref_0 is not None and 'id_ref_0' not in already_processed:
            already_processed.append('id_ref_0')
            outfile.write(' id_ref_0=%s' % (quote_attrib(self.id_ref_0), ))
        if self.id_ref_1 is not None and 'id_ref_1' not in already_processed:
            already_processed.append('id_ref_1')
            outfile.write(' id_ref_1=%s' % (quote_attrib(self.id_ref_1), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.distance is not None and 'distance' not in already_processed:
            already_processed.append('distance')
            outfile.write(' distance="%s"' % self.gds_format_double(self.distance, input_name='distance'))
    def exportChildren(self, outfile, level, namespace_='phy:', name_='CladeRelation', fromsubclass_=False):
        if self.confidence:
            self.confidence.export(outfile, level, namespace_, name_='confidence')
    def hasContent_(self):
        if (
            self.confidence is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CladeRelation'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id_ref_0 is not None and 'id_ref_0' not in already_processed:
            already_processed.append('id_ref_0')
            showIndent(outfile, level)
            outfile.write('id_ref_0 = %s,\n' % (self.id_ref_0,))
        if self.id_ref_1 is not None and 'id_ref_1' not in already_processed:
            already_processed.append('id_ref_1')
            showIndent(outfile, level)
            outfile.write('id_ref_1 = %s,\n' % (self.id_ref_1,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))
        if self.distance is not None and 'distance' not in already_processed:
            already_processed.append('distance')
            showIndent(outfile, level)
            outfile.write('distance = %e,\n' % (self.distance,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.confidence is not None:
            showIndent(outfile, level)
            outfile.write('confidence=model_.Confidence(\n')
            self.confidence.exportLiteral(outfile, level, name_='confidence')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id_ref_0', node)
        if value is not None and 'id_ref_0' not in already_processed:
            already_processed.append('id_ref_0')
            self.id_ref_0 = value
        value = find_attr_value_('id_ref_1', node)
        if value is not None and 'id_ref_1' not in already_processed:
            already_processed.append('id_ref_1')
            self.id_ref_1 = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('distance', node)
        if value is not None and 'distance' not in already_processed:
            already_processed.append('distance')
            try:
                self.distance = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (distance): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'confidence':
            obj_ = Confidence.factory()
            obj_.build(child_)
            self.set_confidence(obj_)
# end class CladeRelation


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'phyloxml'
        rootClass = Phyloxml
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_=rootTag,
##         namespacedef_='xmlns:phy="http://www.phyloxml.org/1.10/phyloxml.xsd"')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'phyloxml'
        rootClass = Phyloxml
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="phyloxml",
##         namespacedef_='xmlns:phy="http://www.phyloxml.org/1.10/phyloxml.xsd"')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'phyloxml'
        rootClass = Phyloxml
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('#from phyloxml import *\n\n')
##     sys.stdout.write('import phyloxml as model_\n\n')
##     sys.stdout.write('rootObj = model_.rootTag(\n')
##     rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##     sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "Accession",
    "Annotation",
    "BinaryCharacterList",
    "BinaryCharacters",
    "BranchColor",
    "Clade",
    "CladeRelation",
    "Confidence",
    "Date",
    "Distribution",
    "DomainArchitecture",
    "Events",
    "Id",
    "MolSeq",
    "Phylogeny",
    "Phyloxml",
    "Point",
    "Polygon",
    "Property",
    "ProteinDomain",
    "Reference",
    "Sequence",
    "SequenceRelation",
    "Taxonomy",
    "Uri"
    ]
