.\"Text automatically generated by txt2man
.TH pyenigma.py 1 "26 Apr 2015" "" ""
.SH NAME
\fBpyenigma.py \fP- encrypt/decrypt text according to Enigma machine key settings
.SH SYNOPSIS
.nf
.fam C
pyenigma.py [\fB-h\fP] [\fB-k\fP \fIKEY_FILE\fP] [\fB-d\fP \fIDAY\fP] [\fB-r\fP \fIROTOR\fP [\fIROTOR\fP \.\.\.]]
            [\fB-i\fP \fIRING_SETTING\fP [\fIRING_SETTING\fP \.\.\.]]
            [\fB-p\fP \fIPLUGBOARD\fP [\fIPLUGBOARD\fP \.\.\.]] [\fB-u\fP \fIREFLECTOR\fP] [\fB-s\fP \fISTART\fP]
            [\fB-t\fP \fITEXT\fP] [\fB-f\fP \fIFILE\fP] [\fB-x\fP \fIREPLACE_CHAR\fP] [\fB-z\fP] [\fB-v\fP]
.fam T
.fi
.fam T
.fi
.SH DESCRIPTION
pyenigma.py is a command line for processing Enigma messages.
Enigma settings can either be specified by command-line arguments,
or read from a key file. If reading from a key file, the line labeled
with the current day number is used unless the \fB--day\fP argument is provided.
.PP
Text to process can be supplied 3 ways:
.RS
.IP \(bu 3
if \fB--text\fP=\fITEXT\fP is present \fITEXT\fP is processed
.IP \(bu 3
if \fB--file\fP=\fIFILE\fP is present the contents of \fIFILE\fP are processed
.IP \(bu 3
otherwise the text is read from standard input
.RE
.PP
Please see documentation for the description of the file format.
.SH OPTIONS
.TP
.B
\fB-h\fP, \fB--help\fP
show this help message and exit
.TP
.B
\fB-k\fP \fIKEY_FILE\fP, \fB--key-file\fP \fIKEY_FILE\fP
path to key file for daily settings
.TP
.B
\fB-d\fP \fIDAY\fP, \fB--day\fP \fIDAY\fP
use the settings for day \fIDAY\fP when reading key file
.TP
.B
\fB-r\fP \fIROTOR\fP [\fIROTOR\fP \.\.\.], \fB--rotors\fP \fIROTOR\fP [\fIROTOR\fP \.\.\.]
rotor list ordered from left to right; e.g III IV I
.TP
.B
\fB-i\fP \fIRING_SETTING\fP [\fIRING_SETTING\fP \.\.\.], \fB--ring-settings\fP \fIRING_SETTING\fP [\fIRING_SETTING\fP \.\.\.]
ring setting list from left to right; e.g. A A J
.TP
.B
\fB-p\fP \fIPLUGBOARD\fP [\fIPLUGBOARD\fP \.\.\.], \fB--plugboard\fP \fIPLUGBOARD\fP [\fIPLUGBOARD\fP \.\.\.]
plugboard settings
.TP
.B
\fB-u\fP \fIREFLECTOR\fP, \fB--reflector\fP \fIREFLECTOR\fP
reflector name
.TP
.B
\fB-s\fP \fISTART\fP, \fB--start\fP \fISTART\fP
starting position
.TP
.B
\fB-t\fP \fITEXT\fP, \fB--text\fP \fITEXT\fP
text to process
.TP
.B
\fB-f\fP \fIFILE\fP, \fB--file\fP \fIFILE\fP
input file to process
.TP
.B
\fB-x\fP \fIREPLACE_CHAR\fP, \fB--replace-char\fP \fIREPLACE_CHAR\fP
if the input text contains chars not found on the
enigma keyboard, replace with this char [default: X]
.TP
.B
\fB-z\fP, \fB--delete-chars\fP
if the input text contains chars not found on the
enigma keyboard, delete them from the input
.TP
.B
\fB-v\fP, \fB--verbose\fP
provide verbose output; include final rotor positions
.SH EXAMPLE
Try these commands to specify settings from the command line:
.PP
.nf
.fam C
    $ pyenigma.py \-r III IV V \-i 1 2 3 \-p AB CD EF GH IJ KL MN \-u B \-s XYZ
    $ pyenigma.py \-r Beta III IV V \-i A B C D \-p 1/2 3/4 5/6 \-u B\-Thin \-s WXYZ

.fam T
.fi
This command will load Enigma settings from a file:
.PP
.nf
.fam C
    $ pyenigma.py \-\-key-file=enigma.keys \-s XYZ \-t HELLOXWORLDX

.fam T
.fi
.SH AUTHOR
Brian Neal <bgneal@gmail.com>
