/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "TriWithLines2DPy.h"
#include "TriWithLines2D.h"

using namespace boost::python;

    void exportTriWithLines2D()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<TriWithLines2D, bases<AVolume2D> >(
        "TriWithLines2D",
        "A class defining a triangular L{AVolume2D} bounded by lines.",
        init<>()
      )
      .def(init<const TriWithLines2D &>())
      .def(
        init<Vector3,Vector3,Vector3>(
          ( arg("vertex0"), arg("vertex1"), arg("vertex2") ),
          "Constructs a triangle with the specified corner points.\n"
          "@type vertex0: L{Vector3}\n"
          "@kwarg vertex0: Coordinate of first corner of the triangle\n"
          "@type vertex1: L{Vector3}\n"
          "@kwarg vertex1: Coordinate of second corner of the triangle\n"
          "@type vertex2: L{Vector3}\n"
          "@kwarg vertex2: Coordinate of third corner of the triangle\n"
        )
      )
      .def(
        "addLine",
        &TriWithLines2D::addLine,
        ( arg("line") ),
        "Adds a line to the box for fitting particles.\n"
        "@type line: L{Line2D}\n"
        "@kwarg line: the line to add to the box\n"
        "@rtype: void\n"
      )
      .def(self_ns::str(self))
      ;
//      boost::python::implicitly_convertible<TriWithLines2D, AVolume2D>();
    }



