/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "SpherePy.h"

using namespace boost::python;

    using boost::python::arg;
    void exportSphere()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

//      class_<Sphere, bases<AGeometricObject> >(
      class_<Sphere>(
        "Sphere",
        "A class defining a sphere in 3D space.", 
        init<>()
      )
      .def(init<const Sphere &>())
      .def(
        init<Vector3,double>(
          ( arg("centre"), arg("radius") ),
          "Constructs a sphere with the specified centre and radius.\n"
	  "N.B. This is not a L{AVolume3D} so cannot be used by C{InsertGenerators}.\n"
          "@type centre: L{Vector3}\n"
          "@kwarg centre: the centre of the sphere\n"
          "@type radius: double\n"
          "@kwarg radius: the radius of the sphere\n"
        )
      )
      .def(
        "Centre",
        &Sphere::Center,
        "Returns the centre of the sphere.\n"
        "@rtype: L{Vector3}\n"
      )
      .def(
        "Radius",
        &Sphere::Radius,
        "Returns the radius of the sphere.\n"
        "@rtype: double\n"
      )
      .def(
        "Id",
        &Sphere::Id,
        "Returns the particle ID of the sphere.\n"
        "@rtype: int\n"
      )
      .def(
        "Tag",
        &Sphere::Tag,
        "Returns the particle tag of the sphere.\n"
        "@rtype: int\n"
      )
      .def(
        "setTag",
        &Sphere::setTag,
	( arg("Tag")),
        "Sets the particle tag of the sphere.\n"
        "@rtype: int\n"
      )
      .def(
        "setId",
        &Sphere::setId,
	( arg("Id")),
        "Sets the id of the sphere.\n"
        "@rtype: int\n"
      )
      .def(self_ns::str(self))
      .def(self_ns::str(self))
      ;
    }
